/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.concurrency;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.concurrency.spring.ThreadManager;

public class ThreadManagerTest {
    @Test(timeout=5000L)
    public void list() throws Exception {
        Thread t = this.startForeverLooping("http-processor-23");
        ThreadManager ozymandias = new ThreadManager();
        ozymandias.listAllThreads(ThreadManager.ThreadSorting.none);
        ozymandias.listAllThreads(ThreadManager.ThreadSorting.id);
        ozymandias.listAllThreads(ThreadManager.ThreadSorting.name);
        long lastId = -1L;
        for (Map.Entry entry : ozymandias.getAllThreads(ThreadManager.ThreadSorting.id)) {
            long id = ((Thread)entry.getKey()).getId();
            Assert.assertTrue((String)"Not in ID order", (id > lastId ? 1 : 0) != 0);
            lastId = id;
        }
        ozymandias.kill(t.getId(), "http-processor-23");
        t.join();
    }

    private Thread startForeverLooping(String name) {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    "Wheeeeeee!!".toUpperCase();
                }
            }
        };
        t.setDaemon(true);
        t.setName(name);
        t.start();
        return t;
    }
}

