/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.concurrency;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.concurrency.TaskExecutionCompletionService;
import uk.ac.warwick.util.concurrency.TaskExecutionService;

public final class TaskExecutionCompletionServiceTest {
    @Test
    public void waitForNothing() throws Exception {
        TaskExecutionService service = new TaskExecutionService(1);
        TaskExecutionCompletionService completionService = service.newCompletionService();
        completionService.waitForCompletion(true);
    }

    @Test(expected=ExecutionException.class)
    public void waitWithException() throws Exception {
        TaskExecutionService service = new TaskExecutionService(1);
        TaskExecutionCompletionService completionService = service.newCompletionService();
        completionService.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                throw new NullPointerException();
            }
        });
        completionService.waitForCompletion(true);
    }

    @Test
    public void waitWithSwallowedException() throws Exception {
        TaskExecutionService service = new TaskExecutionService(1);
        TaskExecutionCompletionService completionService = service.newCompletionService();
        completionService.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                throw new NullPointerException();
            }
        });
        Assert.assertEquals((long)0L, (long)completionService.waitForCompletion(false).size());
    }

    @Test
    public void waitForCompletion() throws Exception {
        TaskExecutionService service = new TaskExecutionService(1);
        TaskExecutionCompletionService completionService = service.newCompletionService();
        final Monitor monitor = new Monitor();
        for (int i = 0; i < 100; ++i) {
            completionService.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    monitor.ping();
                    return null;
                }
            });
        }
        Assert.assertEquals((long)100L, (long)completionService.waitForCompletion(true).size());
        Assert.assertEquals((long)100L, (long)monitor.completedTasks);
    }

    private class Monitor {
        private int completedTasks = 0;

        private Monitor() {
        }

        public synchronized void ping() {
            ++this.completedTasks;
        }
    }
}

