/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.collections.LazyList;

public final class LazyListTest {
    private final Object value = new Object();
    private final LazyList.Factory<Object> factory = new LazyList.Factory<Object>(){

        public Object create() {
            return LazyListTest.this.value;
        }
    };

    @Test
    public void getOutOfBounds() throws Exception {
        ArrayList original = Lists.newArrayList();
        LazyList lazy = LazyList.decorate((List)original, this.factory);
        for (int i = 0; i < 100; ++i) {
            Assert.assertSame((Object)this.value, (Object)lazy.get(i));
        }
    }

    @Test
    public void getInFutureFillsWithLazyFactory() throws Exception {
        ArrayList original = Lists.newArrayList();
        LazyList lazy = LazyList.decorate((List)original, this.factory);
        Assert.assertSame((Object)this.value, (Object)lazy.get(100));
        for (int i = 0; i < 100; ++i) {
            Assert.assertSame((Object)this.value, (Object)lazy.get(i));
        }
    }
}

