/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.memcached.AbstractMemcachedCacheStoreTest;

public class MemcachedCacheStoreTest
extends AbstractMemcachedCacheStoreTest<String, String> {
    @Test
    public void creation() throws Exception {
        CacheEntry string = this.cacheStore.get((Serializable)((Object)"token:abcdefghij"));
        Assert.assertNull((Object)string);
        CacheEntry entry = new CacheEntry((Serializable)((Object)"token:12345"), (Serializable)((Object)"Johnny"));
        this.cacheStore.put(entry, Duration.ofSeconds(10L));
        Assert.assertEquals((Object)entry.getValue(), (Object)this.cacheStore.get((Serializable)((Object)"token:12345")).getValue());
        Assert.assertEquals((Object)entry.getValue(), (Object)this.cacheStore.get((Serializable)((Object)"token:12345")).getValue());
        Map bulk = this.cacheStore.getAll(Arrays.asList("token:12345", "token:67890"));
        Assert.assertEquals((long)2L, (long)bulk.size());
        Assert.assertEquals((Object)entry.getValue(), (Object)((CacheEntry)bulk.get("token:12345")).getValue());
        Assert.assertNull(bulk.get("token:67890"));
        this.assertSize(1);
        Map stats = (Map)this.client.getStats().values().iterator().next();
        Assert.assertEquals((Object)"3", stats.get("get_hits"));
        Assert.assertEquals((Object)Integer.toString(3), stats.get("get_misses"));
        this.cacheStore.clear();
        Assert.assertNull((Object)this.cacheStore.get((Serializable)((Object)"token:12345")));
        this.cacheStore.put(entry, Duration.ofSeconds(10L));
        Assert.assertEquals((Object)entry.getValue(), (Object)this.cacheStore.get((Serializable)((Object)"token:12345")).getValue());
        this.cacheStore.clear();
        Assert.assertNull((Object)this.cacheStore.get((Serializable)((Object)"token:12345")));
    }
}

