/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import java.io.Serializable;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheStoreUnavailableException;
import uk.ac.warwick.util.cache.memcached.AbstractMemcachedCacheStoreTest;
import uk.ac.warwick.util.core.DateTimeUtils;

public class MemcachedCacheStoreNamespaceExpiryTest
extends AbstractMemcachedCacheStoreTest<String, String> {
    @Test
    public void namespaceValueExpiry() {
        OffsetDateTime thePast = OffsetDateTime.of(2040, 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime now = OffsetDateTime.of(2040, 1, 1, 12, 0, 3, 0, ZoneOffset.UTC);
        OffsetDateTime theFuture = OffsetDateTime.of(2040, 1, 1, 12, 0, 6, 0, ZoneOffset.UTC);
        DateTimeUtils.useMockDateTime((TemporalAccessor)thePast, () -> {
            CacheEntry entry = new CacheEntry((Serializable)((Object)"token:12345"), (Serializable)((Object)"Johnny"));
            try {
                this.cacheStore.put(entry, Duration.ofSeconds(10L));
            }
            catch (CacheStoreUnavailableException e) {
                e.printStackTrace();
            }
        });
        DateTimeUtils.useMockDateTime((TemporalAccessor)now, () -> this.cacheStore.get((Serializable)((Object)"token:12345")));
        DateTimeUtils.useMockDateTime((TemporalAccessor)theFuture, () -> this.cacheStore.get((Serializable)((Object)"token:12345")));
        Map stats = (Map)this.client.getStats().values().iterator().next();
        Assert.assertEquals((Object)"2", stats.get("get_hits"));
        Assert.assertEquals((Object)"2", stats.get("get_misses"));
    }
}

