/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.atom;

import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.io.WireFeedInput;
import java.util.List;
import junit.framework.TestCase;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.springframework.core.io.ClassPathResource;
import uk.ac.warwick.util.atom.spring.SitebuilderModule;

public class SitebuilderModuleParserTest
extends TestCase {
    public void testModuleParsing() throws Exception {
        Document document = new SAXBuilder().build(((Object)((Object)this)).getClass().getResourceAsStream("testfeed.xml"));
        Feed feed = (Feed)new WireFeedInput().build(document);
        ClassPathResource romeProps = new ClassPathResource("rome.properties");
        SitebuilderModuleParserTest.assertTrue((String)"rome.properties not found", (boolean)romeProps.exists());
        List entries = feed.getEntries();
        SitebuilderModuleParserTest.assertEquals((int)1, (int)entries.size());
        Entry entry = (Entry)entries.get(0);
        SitebuilderModule module = (SitebuilderModule)entry.getModule("http://go.warwick.ac.uk/elab-schemas/atom");
        SitebuilderModuleParserTest.assertEquals((String)"nickles", (String)module.getPageName());
        SitebuilderModuleParserTest.assertTrue((boolean)module.getAllowSearchEngines());
        SitebuilderModuleParserTest.assertFalse((boolean)module.getShowInLocalNavigation());
        SitebuilderModuleParserTest.assertTrue((boolean)module.getSpanRhs());
        SitebuilderModuleParserTest.assertEquals((String)"Here is the description I'm using for this page", (String)module.getDescription());
        SitebuilderModuleParserTest.assertEquals((String)"horses, play things, lovely times", (String)module.getKeywords());
    }
}

