/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util;

import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.servlet.MultiPartFilter;
import org.mortbay.util.InetAddrPort;

public class JettyServer {
    private static final String SITEBUILDER_CONTENT_ENCODING = "UTF-8";
    private final int port = (int)(Math.random() * 10000.0) + 20000;
    public final String serverAddress = "http://localhost:" + this.port + "/";
    private Server server;

    public void setupServer() throws Exception {
        System.setProperty("org.mortbay.util.URI.charset", SITEBUILDER_CONTENT_ENCODING);
        this.server = new Server();
        this.server.setTrace(true);
        this.server.addListener(new InetAddrPort(this.port));
    }

    public void stopServer() throws Exception {
        this.server.stop();
        this.server = null;
        System.setProperty("org.mortbay.util.URI.charset", SITEBUILDER_CONTENT_ENCODING);
    }

    public void addPort(int port) throws Exception {
        this.server.addListener(new InetAddrPort(port));
    }

    public void startServer(Map<String, String> pathToClassMap) throws Exception {
        WebApplicationHandler handler = new WebApplicationHandler();
        for (Map.Entry<String, String> entry : pathToClassMap.entrySet()) {
            handler.addServlet(entry.getKey(), entry.getValue());
        }
        handler.defineFilter("mpfilter", MultiPartFilter.class.getName());
        handler.addFilterPathMapping("*", "mpfilter", 1);
        this.server.getContext("/").addHandler((HttpHandler)handler);
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V running(Map<String, String> pathToClassMap, Callable<V> fn) throws Exception {
        try {
            if (this.server == null) {
                this.setupServer();
            }
            this.startServer(pathToClassMap);
            V v = fn.call();
            return v;
        }
        finally {
            if (this.server != null) {
                this.stopServer();
            }
        }
    }

    public void running(Map<String, String> pathToClassMap, MyRunnable fn) throws Exception {
        this.running(pathToClassMap, () -> {
            fn.run();
            return null;
        });
    }

    public static class SlowServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Stop interrupting me", e);
            }
            return 200;
        }
    }

    public static class GatewayTimeoutServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 504;
        }
    }

    public static class ServiceUnavailableServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 503;
        }
    }

    public static class PaymentRequiredServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 402;
        }
    }

    public static class UnauthorizedServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 401;
        }
    }

    public static class ForbiddenServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 403;
        }
    }

    public static class GoneServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 410;
        }
    }

    public static class MovedPermanentlyServlet
    extends StatusCodeSettingServlet {
        @Override
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            super.doGet(req, resp);
            resp.addHeader("Location", "http://www.google.com");
        }

        @Override
        int getCode() {
            return 301;
        }
    }

    public static class MovedTemporarilyServlet
    extends StatusCodeSettingServlet {
        @Override
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            super.doGet(req, resp);
            resp.addHeader("Location", "http://www.google.com");
        }

        @Override
        int getCode() {
            return 302;
        }
    }

    public static class NotFoundServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 404;
        }
    }

    public static class OKServlet
    extends StatusCodeSettingServlet {
        @Override
        int getCode() {
            return 200;
        }
    }

    public static abstract class StatusCodeSettingServlet
    extends HttpServlet {
        public static int executionCount = 0;

        abstract int getCode();

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            resp.setStatus(this.getCode());
            ++executionCount;
        }
    }

    public static interface MyRunnable {
        public void run() throws Exception;
    }
}

