/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util;

import java.io.File;
import org.jmock.MockObjectTestCase;
import uk.ac.warwick.util.core.spring.FileUtils;

public abstract class AbstractFileBasedTest
extends MockObjectTestCase {
    protected File root;

    public final void setUp() throws Exception {
        File tmpRoot = File.createTempFile("fileBasedTests", null);
        String tmpName = tmpRoot.getName();
        File rootParent = tmpRoot.getParentFile();
        tmpRoot.delete();
        this.root = new File(rootParent, tmpName);
        if (!this.root.mkdir()) {
            AbstractFileBasedTest.fail((String)("Cannot create " + this.root));
        }
        this.onSetUp();
    }

    protected void onSetUp() throws Exception {
    }

    public File getRoot() {
        return this.root;
    }

    public final void tearDown() throws Exception {
        try {
            FileUtils.recursiveDelete((File)this.root);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.onTearDown();
    }

    protected void onTearDown() throws Exception {
    }

    protected File createDirectory(File directory) {
        if (!directory.mkdir()) {
            AbstractFileBasedTest.fail((String)("cannot create directory " + directory));
        }
        return directory;
    }
}

