package uk.ac.warwick.util.convert;

import com.google.common.io.ByteSource;

import java.io.IOException;
import java.io.InputStream;

/**
 * A ByteSource that wraps a supplier of InputStreams.
 */
public class StreamByteSource extends ByteSource {
  private final IOSupplier<InputStream> supplier;

  private StreamByteSource(IOSupplier<InputStream> supplier) {
    this.supplier = supplier;
  }

  public static StreamByteSource from(IOSupplier<InputStream> supplier) {
    return new StreamByteSource(supplier);
  }
  
  @Override
  public InputStream openStream() throws IOException {
    return supplier.get();
  }
}
