/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.tags;

import java.util.regex.Pattern;
import junit.framework.TestCase;
import uk.ac.warwick.util.web.tags.WrappingUrlTag;

public class WrappingUrlTagTest
extends TestCase {
    public void testUrlStartingWithSlash() throws Exception {
        String input = "/services/its/elab/about/people/mmannion";
        String expected = "/<wbr>services/<wbr>its/<wbr>elab/<wbr>about/<wbr>people/<wbr>mmannion";
        this.assertItWorks(input, expected);
    }

    public void testUrlStartingWithHttp() throws Exception {
        String input = "http://www.warwick.ac.uk/services/its/elab/about/people/mmannion";
        String expected = "http://<wbr>www.warwick.ac.uk/<wbr>services/<wbr>its/<wbr>elab/<wbr>about/<wbr>people/<wbr>mmannion";
        this.assertItWorks(input, expected);
    }

    public void testUrlWithoutLeadingSlash() throws Exception {
        String input = "services/its/elab/about/people/mmannion/";
        String expected = "services/<wbr>its/<wbr>elab/<wbr>about/<wbr>people/<wbr>mmannion/";
        this.assertItWorks(input, expected);
    }

    private void assertItWorks(String input, String expected) {
        WrappingUrlTag tag = new WrappingUrlTag();
        tag.setUrl(input);
        String glueRegex = Pattern.quote("<wbr>");
        WrappingUrlTagTest.assertEquals((String)"Removing glue should yield initial string", (String)input, (String)tag.getWrappableUrl().replaceAll(glueRegex, ""));
        WrappingUrlTagTest.assertEquals((String)"Should equal expected string", (String)expected, (String)tag.getWrappableUrl());
    }
}

