/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.spring.view.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import uk.ac.warwick.util.web.spring.view.json.JSONPRequestValidator;
import uk.ac.warwick.util.web.spring.view.json.JSONView;

public final class JSONViewTest {
    @Test
    public void contentType() throws Exception {
        JSONView view = new JSONView(){

            public JSONObject render(Map<String, Object> model, HttpServletRequest request, List<String> errors) throws Exception {
                return new JSONObject();
            }
        };
        view.setJsonpRequestValidator(JSONPRequestValidator.ALLOW_ALL);
        Assert.assertEquals((Object)"application/json", (Object)view.getContentType());
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HashMap model = Maps.newHashMap();
        view.render((Map)model, (HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        response = new MockHttpServletResponse();
        request.setParameter("jsonp", "callback");
        view.render((Map)model, (HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((Object)"application/javascript", (Object)response.getContentType());
    }

    @Test
    public void render() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        final HashMap model = Maps.newHashMap();
        model.put("a", "b");
        JSONView view = new JSONView(){

            public JSONObject render(Map<String, Object> innerModel, HttpServletRequest request, List<String> errors) throws Exception {
                Assert.assertTrue((boolean)errors.isEmpty());
                Assert.assertEquals((Object)model, innerModel);
                errors.add("error");
                return new JSONObject(){
                    {
                        this.put("a", "b");
                    }
                };
            }
        };
        view.render((Map)model, (HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((Object)new JSONObject("{\"data\":{\"a\":\"b\"},\"errors\":[\"error\"]}").toString(), (Object)new JSONObject(response.getContentAsString()).toString());
    }

    @Test
    public void combine() throws Exception {
        JSONView view1 = new JSONView(){

            public JSONObject render(Map<String, Object> innerModel, HttpServletRequest request, List<String> errors) throws Exception {
                errors.add("error1");
                return new JSONObject(){
                    {
                        this.put("a", 1);
                        this.put("b", true);
                        this.put("c", JSONObject.NULL);
                    }
                };
            }
        };
        JSONView view2 = new JSONView(){

            public JSONObject render(Map<String, Object> innerModel, HttpServletRequest request, List<String> errors) throws Exception {
                errors.add("error2");
                errors.add("error3");
                return new JSONObject(){
                    {
                        this.put("c", new JSONArray(){
                            {
                                this.put("a");
                                this.put("b");
                                this.put("c");
                            }
                        });
                        this.put("d", "yes");
                        this.put("E", 0.1);
                    }
                };
            }
        };
        JSONView combined = JSONView.combine((JSONView[])new JSONView[]{view1, view2});
        ArrayList errors = Lists.newArrayList();
        JSONObject object = combined.render(null, (HttpServletRequest)new MockHttpServletRequest(), (List)errors);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"error1", "error2", "error3"}), (Object)errors);
        Assert.assertEquals((Object)new JSONObject(){
            {
                this.put("a", 1);
                this.put("b", true);
                this.put("c", new JSONArray(){
                    {
                        this.put("a");
                        this.put("b");
                        this.put("c");
                    }
                });
                this.put("d", "yes");
                this.put("E", 0.1);
            }
        }.toString(), (Object)object.toString());
    }
}

