/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter.stack;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.web.filter.stack.FilterMappingParser;
import uk.ac.warwick.util.web.filter.stack.FilterMappingParserImpl;

public class FilterMappingParserTest {
    FilterMappingParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new FilterMappingParserImpl();
    }

    @Test
    public void root() {
        this.assertMatches("/", "/");
        this.assertDoesNotMatch("/", "/path", "/render/file.css");
    }

    @Test
    public void prefixes() {
        this.assertMatches("/render/*", "/render/renderPage.htm", "/render/", "/render/api/yes");
        this.assertDoesNotMatch("/render/*", "/hello", "/Render", "/context/render/", "/context/render/renderPage.htm");
    }

    @Test
    public void missingSlash() {
        this.assertMatches("/file/*", "/file", "/file/", "/file/3");
        this.assertDoesNotMatch("/file/*", "/files");
    }

    @Test
    public void extensions() {
        this.assertMatches("*.css", "/render/page.css", "/page.css", "/whatever/blah.do.css");
        this.assertDoesNotMatch("*.css", "/render/css", "/edit/page.css/more");
    }

    @Test
    public void wildcardExtension() {
        this.assertMatches("/render/renderPage.*", "/render/renderPage.htm", "/render/renderPage.html");
        this.assertDoesNotMatch("/render/renderPage.*", "/render/renderPage/anything", "/hello", "/Render", "/context/render/", "/context/render/renderPage.htm");
    }

    @Test
    public void wildcardNonExtensionPrefix() {
        this.assertMatches("/render/renderPage*", "/render/renderPage.htm", "/render/renderPage.html", "/render/renderPage/foo.html");
        this.assertDoesNotMatch("/render/renderPage*", "/foo/renderPage/anything");
        this.assertMatches("/render/renderPag?f", "/render/renderPagef", "/render/renderPagaf");
        this.assertMatches("/render/renderPag?", "/render/renderPage", "/render/renderPaga");
        this.assertMatches("/foo", "/foo");
    }

    @Test
    public void middleWildcard() {
        String mapping = "/api/*/entries.json";
        this.assertMatches("/api/*/entries.json", "/api/v1/entries.json", "/api/v2/entries.json");
        this.assertDoesNotMatch("/api/*/entries.json", "/api/v1/anything");
    }

    @Test
    public void exact() {
        this.assertMatches("/edit/api/deleteWebsite", "/edit/api/deleteWebsite");
        this.assertDoesNotMatch("/edit/api/deleteWebsite", "/edit/api/deleteWebsites", "/do/edit/api/deleteWebsite");
    }

    @Test
    public void longerMappingThanUrl() {
        this.assertDoesNotMatch("/edit/api/deleteWebsite", "/edit");
    }

    private void assertMatches(String mapping, String ... urls) {
        for (String url : urls) {
            Assert.assertTrue((String)(mapping + " didn't match " + url), (boolean)this.parser.matches(url, mapping));
        }
    }

    private void assertDoesNotMatch(String mapping, String ... urls) {
        for (String url : urls) {
            Assert.assertFalse((String)(mapping + " matched " + url), (boolean)this.parser.matches(url, mapping));
        }
    }
}

