/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter;

import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.web.filter.RequestIPAddressHolder;
import uk.ac.warwick.util.web.filter.RequestIPAddressHolderImpl;

public class RequestIPAddressHolderImplTest {
    private Collection<String> localAddresses = Arrays.asList("137.205.194.5", "137.205.194.6");

    @Test
    public void testRegularAddress() {
        Assert.assertEquals((Object)"137.205.194.1", (Object)this.createReqHolder("137.205.194.1").getNonLocalAddress());
        Assert.assertTrue((boolean)this.createReqHolder("2.14.93.254").hasNonLocalAddress());
    }

    @Test
    public void testExplicitLocalAddress() {
        RequestIPAddressHolder ip = this.createReqHolder("137.205.194.5");
        Assert.assertEquals((Object)"127.0.0.1", (Object)ip.getNonLocalAddress());
        Assert.assertFalse((boolean)ip.hasNonLocalAddress());
    }

    @Test
    public void test172PrivateSubnet() {
        Assert.assertTrue((String)"172.1.* is nonlocal", (boolean)this.createReqHolder("172.1.2.3").hasNonLocalAddress());
        Assert.assertFalse((String)"172.16.* is local", (boolean)this.createReqHolder("172.16.2.3").hasNonLocalAddress());
        Assert.assertTrue((String)"vpn is nonlocal", (boolean)this.createReqHolder("172.20.251.64").hasNonLocalAddress());
        Assert.assertTrue((String)"resnet is nonlocal", (boolean)this.createReqHolder("172.27.1.1").hasNonLocalAddress());
        Assert.assertTrue((String)"hotspot is nonlocal", (boolean)this.createReqHolder("172.31.255.255").hasNonLocalAddress());
    }

    @Test
    public void test10PrivateSubnet() {
        Assert.assertTrue((String)"10.* is nonlocal", (boolean)this.createReqHolder("10.1.2.3").hasNonLocalAddress());
    }

    @Test
    public void multipleXffValues() {
        RequestIPAddressHolder ip = this.createReqHolder("137.205.194.5", "172.16.10.10", "137.205.194.200", "172.17.10.10");
        Assert.assertEquals((String)"should use first nonlocal address found", (Object)"137.205.194.200", (Object)ip.getNonLocalAddress());
    }

    private RequestIPAddressHolder createReqHolder(String ... xffAddresses) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRemoteAddr("127.0.0.1");
        req.addHeader("X-Forwarded-For", (Object)StringUtils.join((String[])xffAddresses, (String)","));
        RequestIPAddressHolderImpl ip = new RequestIPAddressHolderImpl((HttpServletRequest)req, this.localAddresses);
        return ip;
    }
}

