/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.filter;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.web.filter.InetAddressRange;

public class InetAddressRangeTest {
    private void check(InetAddressRange range, List<String> contained, List<String> uncontained) throws Exception {
        for (String ip : contained) {
            Assert.assertTrue((String)(range + " should contain " + ip), (boolean)range.contains(InetAddress.getByName(ip)));
        }
        for (String ip : uncontained) {
            Assert.assertFalse((String)(range + " should not contain " + ip), (boolean)range.contains(InetAddress.getByName(ip)));
        }
    }

    @Test
    public void test10Subnet() throws Exception {
        this.check(InetAddressRange.of((String)"10.0.0.0", (String)"10.0.0.10"), Lists.newArrayList((Object[])new String[]{"10.0.0.0", "10.0.0.10"}), Lists.newArrayList((Object[])new String[]{"10.1.0.5"}));
    }

    @Test
    public void test172Subnet() throws Exception {
        this.check(InetAddressRange.of((String)"172.16.0.0", (String)"172.31.255.255"), Lists.newArrayList((Object[])new String[]{"172.16.0.0", "172.16.1.2", "172.16.255.255", "172.29.1.1", "172.31.50.50"}), Lists.newArrayList((Object[])new String[]{"172.15.0.0", "171.16.0.0"}));
    }
}

