/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import uk.ac.warwick.util.web.WarwickHttpServletRequest;

public class WarwickHttpServletRequestTest {
    @Test
    public void getHeaderString() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("Exists", (Object)"Test");
        original.addHeader("Host", (Object)"localhost:8080");
        original.addHeader("X-Requested-URI", (Object)"http://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((Object)"Test", (Object)wrapped.getHeader("Exists"));
        Assert.assertNull((Object)wrapped.getHeader("NonExistant"));
        Assert.assertEquals((Object)"start.warwick.ac.uk", (Object)wrapped.getHeader("Host"));
    }

    @Test
    public void getRemoteAddr() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet((Object[])new String[]{"137.205.194.132"}));
        original.setRemoteAddr("1.2.3.4");
        Assert.assertEquals((Object)"1.2.3.4", (Object)wrapped.getRemoteAddr());
        original.addHeader("X-Forwarded-For", (Object)"127.0.0.1,137.205.194.132,1.2.3.4");
        Assert.assertEquals((Object)"1.2.3.4", (Object)wrapped.getRemoteAddr());
    }

    @Test
    public void getRequestURI() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"http://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((Object)"/something", (Object)wrapped.getRequestURI());
    }

    @Test
    public void getRequestURL() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"http://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((Object)"http://start.warwick.ac.uk/something?yes=no", (Object)wrapped.getRequestURL().toString());
    }

    @Test
    public void getScheme() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"https://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((Object)"https", (Object)wrapped.getScheme());
    }

    @Test
    public void getServerName() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"https://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((Object)"start.warwick.ac.uk", (Object)wrapped.getServerName());
    }

    @Test
    public void getServerPort() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"https://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((long)443L, (long)wrapped.getServerPort());
    }

    @Test
    public void getQueryString() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"https://start.warwick.ac.uk/something?yes=no");
        Assert.assertEquals((Object)"yes=no", (Object)wrapped.getQueryString());
    }

    @Test
    public void isSecure() {
        MockHttpServletRequest original = new MockHttpServletRequest();
        WarwickHttpServletRequest wrapped = new WarwickHttpServletRequest((HttpServletRequest)original, (Set)Sets.newHashSet());
        original.addHeader("X-Requested-URI", (Object)"https://start.warwick.ac.uk/something?yes=no");
        Assert.assertTrue((boolean)wrapped.isSecure());
    }
}

