/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates.legacy;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.Temporal;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.threeten.extra.LocalDateRange;
import org.threeten.extra.Weeks;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.termdates.legacy.Term;
import uk.ac.warwick.util.termdates.legacy.TermFactoryImpl;
import uk.ac.warwick.util.termdates.legacy.TermNotFoundException;

public final class TermFactoryImplTest {
    @Test
    public void constructor() throws Exception {
        TermFactoryImpl bean = new TermFactoryImpl();
        LinkedList dates = bean.getTermDates();
        Term thirdTerm = (Term)dates.get(2);
        LocalDate thirdTermStart = thirdTerm.getStartDate();
        LocalDate april23rd = LocalDate.of(2007, Month.APRIL, 23);
        Assert.assertTrue((boolean)DateTimeUtils.isSameDay((Temporal)thirdTermStart, (Temporal)april23rd));
        Assert.assertEquals((long)1L, (long)thirdTerm.getWeekNumber((Temporal)april23rd));
    }

    @Test
    public void data() throws Exception {
        for (Term term : new TermFactoryImpl().getTermDates()) {
            Assert.assertTrue((String)("Term ends before it finishes (term starting " + term.getStartDate() + ")"), (boolean)term.getStartDate().isBefore(term.getEndDate()));
            int weeks = Weeks.between((Temporal)term.getStartDate(), (Temporal)term.getEndDate()).getAmount();
            Assert.assertTrue((String)"Term has a weird length", (weeks >= 9 && weeks <= 10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void enoughDates() throws Exception {
        int futureTerms = 6;
        TermFactoryImpl factory = new TermFactoryImpl();
        LocalDate d = LocalDate.now().withMonth(7);
        int i = 0;
        try {
            Term term = factory.getTermFromDate((Temporal)d);
            for (i = 1; i < 6; ++i) {
                term = factory.getNextTerm(term);
            }
        }
        catch (TermNotFoundException e) {
            Assert.fail((String)("Expected at least 6 future terms in data, but only got " + i + ". Update the terms file!"));
        }
    }

    @Test
    public void getAcademicWeeksForYear() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        List weeks = factory.getAcademicWeeksForYear((Temporal)LocalDate.of(2007, Month.APRIL, 23));
        Assert.assertEquals((long)52L, (long)weeks.size());
        Pair week1 = (Pair)weeks.get(0);
        Assert.assertEquals((long)1L, (long)((Integer)week1.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2006, Month.OCTOBER, 2), (LocalDate)LocalDate.of(2006, Month.OCTOBER, 9)), (Object)week1.getRight());
        Pair week10 = (Pair)weeks.get(9);
        Assert.assertEquals((long)10L, (long)((Integer)week10.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2006, Month.DECEMBER, 4), (LocalDate)LocalDate.of(2006, Month.DECEMBER, 11)), (Object)week10.getRight());
        Pair week20 = (Pair)weeks.get(19);
        Assert.assertEquals((long)20L, (long)((Integer)week20.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.FEBRUARY, 12), (LocalDate)LocalDate.of(2007, Month.FEBRUARY, 19)), (Object)week20.getRight());
        Pair week30 = (Pair)weeks.get(29);
        Assert.assertEquals((long)30L, (long)((Integer)week30.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.APRIL, 23), (LocalDate)LocalDate.of(2007, Month.APRIL, 30)), (Object)week30.getRight());
        Pair week52 = (Pair)weeks.get(51);
        Assert.assertEquals((long)52L, (long)((Integer)week52.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.SEPTEMBER, 24), (LocalDate)LocalDate.of(2007, Month.OCTOBER, 1)), (Object)week52.getRight());
    }

    @Test
    public void getAcademicWeeksForYear2014() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        List weeks = factory.getAcademicWeeksForYear((Temporal)LocalDate.of(2014, Month.NOVEMBER, 1));
        Assert.assertEquals((long)53L, (long)weeks.size());
        Pair week1 = (Pair)weeks.get(0);
        Assert.assertEquals((long)1L, (long)((Integer)week1.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2014, Month.SEPTEMBER, 29), (LocalDate)LocalDate.of(2014, Month.OCTOBER, 6)), (Object)week1.getRight());
        Pair week53 = (Pair)weeks.get(52);
        Assert.assertEquals((long)53L, (long)((Integer)week53.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2015, Month.SEPTEMBER, 28), (LocalDate)LocalDate.of(2015, Month.OCTOBER, 5)), (Object)week53.getRight());
    }

    @Test
    public void getAcademicWeeksForYear2015() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        List weeks = factory.getAcademicWeeksForYear((Temporal)LocalDate.of(2015, Month.NOVEMBER, 1));
        Assert.assertEquals((long)52L, (long)weeks.size());
        Pair week1 = (Pair)weeks.get(0);
        Assert.assertEquals((long)1L, (long)((Integer)week1.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2015, Month.OCTOBER, 5), (LocalDate)LocalDate.of(2015, Month.OCTOBER, 12)), (Object)week1.getRight());
        Pair week52 = (Pair)weeks.get(51);
        Assert.assertEquals((long)52L, (long)((Integer)week52.getLeft()).intValue());
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2016, Month.SEPTEMBER, 26), (LocalDate)LocalDate.of(2016, Month.OCTOBER, 3)), (Object)week52.getRight());
    }

    @Test
    public void getAcademicWeek() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        LocalDateRange week1 = LocalDateRange.of((LocalDate)LocalDate.of(2006, Month.OCTOBER, 2), (LocalDate)LocalDate.of(2006, Month.OCTOBER, 9));
        Assert.assertEquals((Object)week1, (Object)factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2), 1));
        Assert.assertEquals((Object)week1, (Object)factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2).plusMonths(5L), 1));
        try {
            factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2).plusYears(100L), 1);
            Assert.fail((String)"Should have exceptioned");
        }
        catch (TermNotFoundException termNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2006, Month.DECEMBER, 4), (LocalDate)LocalDate.of(2006, Month.DECEMBER, 11)), (Object)factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2), 10));
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.FEBRUARY, 12), (LocalDate)LocalDate.of(2007, Month.FEBRUARY, 19)), (Object)factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2), 20));
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.APRIL, 23), (LocalDate)LocalDate.of(2007, Month.APRIL, 30)), (Object)factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2), 30));
        Assert.assertEquals((Object)LocalDateRange.of((LocalDate)LocalDate.of(2007, Month.SEPTEMBER, 24), (LocalDate)LocalDate.of(2007, Month.OCTOBER, 1)), (Object)factory.getAcademicWeek((Temporal)LocalDate.of(2006, Month.OCTOBER, 2), 52));
    }

    @Test
    public void sbtwo3948() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        LocalDate monday = LocalDate.of(2011, Month.APRIL, 25);
        Term term = factory.getTermFromDate((Temporal)monday);
        Assert.assertEquals((Object)LocalDate.of(2011, Month.APRIL, 25), (Object)term.getStartDate());
        Assert.assertEquals((Object)LocalDate.of(2011, Month.JULY, 3), (Object)term.getEndDate());
        Assert.assertEquals((Object)Term.TermType.summer, (Object)term.getTermType());
        Assert.assertEquals((long)1L, (long)term.getWeekNumber((Temporal)monday));
        Assert.assertEquals((long)30L, (long)term.getAcademicWeekNumber((Temporal)monday));
        Assert.assertEquals((long)21L, (long)term.getCumulativeWeekNumber((Temporal)monday));
        Assert.assertEquals((long)1L, (long)term.getWeekNumber((Temporal)monday.with(DayOfWeek.SATURDAY)));
        Assert.assertEquals((long)30L, (long)term.getAcademicWeekNumber((Temporal)monday.with(DayOfWeek.SATURDAY)));
        Assert.assertEquals((long)21L, (long)term.getCumulativeWeekNumber((Temporal)monday.with(DayOfWeek.SATURDAY)));
        Assert.assertEquals((long)2L, (long)term.getWeekNumber((Temporal)monday.plusWeeks(1L)));
        Assert.assertEquals((long)31L, (long)term.getAcademicWeekNumber((Temporal)monday.plusWeeks(1L)));
        Assert.assertEquals((long)22L, (long)term.getCumulativeWeekNumber((Temporal)monday.plusWeeks(1L)));
    }

    @Test
    public void sanity() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        LinkedList terms = factory.getTermDates();
        Term lastTerm = null;
        for (Term term : terms) {
            if (lastTerm != null) {
                Assert.assertTrue((boolean)term.getStartDate().isAfter(lastTerm.getEndDate()));
                switch (lastTerm.getTermType()) {
                    case autumn: {
                        Assert.assertEquals((Object)Term.TermType.spring, (Object)term.getTermType());
                        break;
                    }
                    case spring: {
                        Assert.assertEquals((Object)Term.TermType.summer, (Object)term.getTermType());
                        break;
                    }
                    case summer: {
                        Assert.assertEquals((Object)Term.TermType.autumn, (Object)term.getTermType());
                    }
                }
            } else {
                Assert.assertEquals((Object)Term.TermType.autumn, (Object)term.getTermType());
            }
            Assert.assertTrue((boolean)term.getStartDate().isBefore(term.getEndDate()));
            LocalDate actualEndDate = term.getEndDate();
            while (actualEndDate.getDayOfWeek() != term.getStartDate().getDayOfWeek()) {
                actualEndDate = actualEndDate.plusDays(1L);
            }
            Assert.assertEquals((long)10L, (long)Weeks.between((Temporal)term.getStartDate(), (Temporal)actualEndDate).getAmount());
            lastTerm = term;
        }
    }

    @Test
    public void tab2625() throws Exception {
        TermFactoryImpl factory = new TermFactoryImpl();
        LocalDate monday = LocalDate.of(2011, Month.APRIL, 25);
        Term term = factory.getTermFromDate((Temporal)monday);
        Assert.assertEquals((Object)term, (Object)factory.getTermFromDate((Temporal)term.getEndDate()));
    }
}

