/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.queue.conversion;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.action.CustomAction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import uk.ac.warwick.util.queue.conversion.JsonMessageConverter;
import uk.ac.warwick.util.queue.conversion.TestItem;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"service-beans.xml"})
public class JsonMessageConverterTest {
    private Mockery m = new JUnit4Mockery();
    private JsonMessageConverter converter;

    @Test
    public void autowiring() throws Exception {
        TestItem myObject = new TestItem("Aska", 900).addChild(new TestItem("Sasha", 300)).addChild(new TestItem("Vaska", 350).addChild(new TestItem("Danuta", 200)));
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy());
        this.converter.setObjectMapper(mapper);
        final Session session = (Session)this.m.mock(Session.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((Session)this.oneOf(session)).createTextMessage((String)this.with(1.any(String.class)));
                this.will((Action)JsonMessageConverterTest.this.returnTextMessage().expectingProperty("itemType", "my-message-type"));
            }
        });
        TextMessage message = (TextMessage)this.converter.toMessage((Object)myObject, session);
        String text = message.getText();
        System.err.println(text);
        Assert.assertThat((Object)text, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"current_age"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testServiceBean"))));
        TestItem recreatedObject = (TestItem)this.converter.fromMessage((Message)message);
        Assert.assertThat((Object)recreatedObject, (Matcher)Matchers.hasProperty((String)"currentAge", (Matcher)Matchers.is((Object)900)));
        Assert.assertThat((Object)recreatedObject, (Matcher)Matchers.hasProperty((String)"testServiceBean", (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue()))));
        Assert.assertThat((Object)recreatedObject.getChildren().get(0), (Matcher)Matchers.hasProperty((String)"testServiceBean", (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue()))));
    }

    private TextMessageAction returnTextMessage() {
        return new TextMessageAction();
    }

    @Autowired
    public void setConverter(JsonMessageConverter converter) {
        this.converter = converter;
    }

    private class TextMessageAction
    extends CustomAction {
        final TextMessage t;

        public TextMessageAction() {
            super("return TextMessage");
            this.t = (TextMessage)JsonMessageConverterTest.this.m.mock(TextMessage.class);
        }

        public Object invoke(final Invocation invocation) throws Throwable {
            JsonMessageConverterTest.this.m.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TextMessage)this.allowing(TextMessageAction.this.t)).getText();
                    this.will(1.returnValue((Object)invocation.getParameter(0)));
                }
            });
            return this.t;
        }

        public TextMessageAction expectingProperty(final String name, final String value) throws Exception {
            JsonMessageConverterTest.this.m.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TextMessage)this.oneOf(TextMessageAction.this.t)).setStringProperty(name, value);
                    ((TextMessage)this.allowing(TextMessageAction.this.t)).getStringProperty(name);
                    this.will(2.returnValue((Object)value));
                }
            });
            return this;
        }
    }
}

