/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.AbstractJUnit4FileBasedTest;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.core.spring.FileUtils;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.impl.FileSystemBackedHashResolver;
import uk.ac.warwick.util.files.hash.impl.SHAFileHasher;
import uk.ac.warwick.util.files.impl.LocalFilesystemFileStore;

public class LocalFilesystemFileStoreTest
extends AbstractJUnit4FileBasedTest {
    private static final byte[] DATA = "Hello".getBytes();
    private LocalFilesystemFileStore fileStore;
    private MaintenanceModeFlags flags;
    private FileHashResolver resolver;
    private FileReferenceCreationStrategy strategy;
    private Mockery m = new Mockery();
    private File tempDir;

    @Before
    public void setUpHere() throws Exception {
        this.tempDir = File.createTempFile("aaa", "bbb");
        this.tempDir.delete();
        this.tempDir.mkdir();
        this.flags = new MaintenanceModeFlags(){

            public boolean isInMaintenanceMode() {
                return false;
            }
        };
        this.strategy = (FileReferenceCreationStrategy)this.m.mock(FileReferenceCreationStrategy.class);
        final HashInfoDAO sbd = (HashInfoDAO)this.m.mock(HashInfoDAO.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(sbd);
            }
        });
        this.resolver = new FileSystemBackedHashResolver((FileHasher)new SHAFileHasher(), "html", LocalFilesystemFileStoreTest.getRoot(), sbd, this.flags);
        this.fileStore = new LocalFilesystemFileStore(Collections.singletonMap("html", this.resolver), this.strategy);
    }

    @After
    public void tearDownHere() throws Exception {
        FileUtils.recursiveDelete((File)this.tempDir);
        this.tempDir.deleteOnExit();
    }

    @Test
    public void storeHashHtmlFile() throws Exception {
        final Storeable s = (Storeable)this.m.mock(Storeable.class);
        final Storeable.StorageStrategy ss = (Storeable.StorageStrategy)this.m.mock(Storeable.StorageStrategy.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileReferenceCreationStrategy)this.oneOf(LocalFilesystemFileStoreTest.this.strategy)).select((ByteSource)this.with(3.any(ByteSource.class)));
                this.will(3.returnValue((Object)FileReferenceCreationStrategy.Target.hash));
                ((Storeable)this.allowing(s)).getPath();
                this.will(3.returnValue((Object)"/file.htm"));
                ((Storeable)this.allowing(s)).getStrategy();
                this.will(3.returnValue((Object)ss));
                ((Storeable.StorageStrategy)this.allowing(ss)).getRootPath();
                this.will(3.returnValue((Object)AbstractJUnit4FileBasedTest.getRoot().getAbsolutePath()));
            }
        });
        this.fileStore.store(s, "html", ByteSource.wrap((byte[])DATA));
        File createdFile = new File(LocalFilesystemFileStoreTest.getRoot(), "f7/ff/9e/8b/7b/b2e09b70935a5d785e0cc5d9d0abf0.data");
        Assert.assertEquals((Object)new String(DATA), (Object)FileCopyUtils.copyToString((Reader)new FileReader(createdFile)));
        Assert.assertEquals(Collections.singletonList("ff"), this.fileStore.list(ss, "f7/").collect(Collectors.toList()));
        Assert.assertEquals(Collections.singletonList("b2e09b70935a5d785e0cc5d9d0abf0.data"), this.fileStore.list(ss, "f7/ff/9e/8b/7b").collect(Collectors.toList()));
        this.m.assertIsSatisfied();
    }
}

