/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.files.imageresize.LazyCreationFileOutputStream;

public class LazyCreationFileOutputStreamTest {
    @Test
    public void createFileOnWrite() throws Exception {
        File root = new File(System.getProperty("java.io.tmpdir"));
        Assert.assertTrue((boolean)root.exists());
        File newFile = new File(root, "create" + new Random().nextInt(100));
        newFile.deleteOnExit();
        LazyCreationFileOutputStream output = new LazyCreationFileOutputStream(newFile);
        Assert.assertFalse((boolean)newFile.exists());
        output.write("DATA".getBytes());
        output.write("DATA!".getBytes());
        Assert.assertTrue((boolean)newFile.exists());
        output.close();
        Assert.assertEquals((Object)"DATADATA!", (Object)FileCopyUtils.copyToString((Reader)new FileReader(newFile)));
    }
}

