/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;
import uk.ac.warwick.util.csv.CSVLineReader;
import uk.ac.warwick.util.csv.CSVLineWriter;
import uk.ac.warwick.util.csv.GoodCsvDocument;

public final class CreateCSVDocumentTest
extends MockObjectTestCase {
    public void testCreateCSVDocumentWriterIsCalled() throws IOException {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        String rowAcolB = "rowAcolB";
        String rowBcolA = "rowBcolA";
        String rowBcolB = "rowBcolB";
        Object rowA = new Object();
        Object rowB = new Object();
        Mock mockWriter = this.mock(CSVLineWriter.class);
        mockWriter.expects(this.once()).method("getNoOfColumns").with((Constraint)this.eq(rowA)).will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(0)).will(this.returnValue(rowAcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(1)).will(this.returnValue(rowAcolB));
        mockWriter.expects(this.once()).method("getNoOfColumns").with((Constraint)this.eq(rowB)).will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowB), (Constraint)this.eq(0)).will(this.returnValue(rowBcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowB), (Constraint)this.eq(1)).will(this.returnValue(rowBcolB));
        StringWriter writer = new StringWriter();
        GoodCsvDocument document = new GoodCsvDocument((CSVLineWriter)mockWriter.proxy(), null);
        document.addLine(rowA);
        document.addLine(rowB);
        document.write((Writer)writer);
        String s = writer.toString();
        String expectedString = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + rowAcolB + fieldWrapper + lineSeperator;
        expectedString = expectedString + fieldWrapper + rowBcolA + fieldWrapper + discriminator + fieldWrapper + rowBcolB + fieldWrapper + lineSeperator;
        CreateCSVDocumentTest.assertEquals((String)expectedString, (String)s);
    }

    public void testCreateCSVDocumentWriterHandlesNull() throws IOException {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        Object rowAcolB = null;
        Object rowA = new Object();
        Mock mockWriter = this.mock(CSVLineWriter.class);
        mockWriter.expects(this.once()).method("getNoOfColumns").with((Constraint)this.eq(rowA)).will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(0)).will(this.returnValue(rowAcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(1)).will(this.returnValue(rowAcolB));
        StringWriter writer = new StringWriter();
        GoodCsvDocument document = new GoodCsvDocument((CSVLineWriter)mockWriter.proxy(), null);
        document.addLine(rowA);
        document.write((Writer)writer);
        String s = writer.toString();
        String expectedString = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + "" + fieldWrapper + lineSeperator;
        CreateCSVDocumentTest.assertEquals((String)expectedString, (String)s);
    }

    public void testCreateCSVDocumentDiscriminatorsAreEscaped() throws IOException {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowA" + discriminator + "colA";
        String rowAcolB = "rowAcolB";
        Object rowA = new Object();
        Mock mockWriter = this.mock(CSVLineWriter.class);
        mockWriter.expects(this.once()).method("getNoOfColumns").will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(0)).will(this.returnValue(rowAcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(1)).will(this.returnValue(rowAcolB));
        StringWriter writer = new StringWriter();
        GoodCsvDocument document = new GoodCsvDocument((CSVLineWriter)mockWriter.proxy(), null);
        document.addLine(rowA);
        document.write((Writer)writer);
        String s = writer.toString();
        String expectedString = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + rowAcolB + fieldWrapper + lineSeperator;
        CreateCSVDocumentTest.assertEquals((String)expectedString, (String)s);
    }

    public void testReadCSVDocumentReaderIsCalled() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String rowAcolA = "rowAcolA";
        String rowAcolB = "rowAcolB";
        String rowBcolA = "rowBcolA";
        String rowBcolB = "rowBcolB";
        Object rowA = new Object();
        Object rowB = new Object();
        Mock mockReader = this.mock(CSVLineReader.class);
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowB));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowB), this.eq(0), this.eq(rowBcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowB), this.eq(1), this.eq(rowBcolB)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowB));
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowA));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(0), this.eq(rowAcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(1), this.eq(rowAcolB)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowA));
        mockReader.expects(this.atLeastOnce()).method("endData");
        String source = rowAcolA + discriminator + rowAcolB + lineSeperator;
        source = source + rowBcolA + discriminator + rowBcolB + lineSeperator;
        StringReader reader = new StringReader(source);
        GoodCsvDocument document = new GoodCsvDocument(null, (CSVLineReader)mockReader.proxy());
        document.read((Reader)reader);
        CreateCSVDocumentTest.assertEquals((String)"number of rows", (int)2, (int)document.getNumberOfRows());
        CreateCSVDocumentTest.assertEquals((String)"first row", (Object)rowA, (Object)document.getRow(0));
        CreateCSVDocumentTest.assertEquals((String)"second row", (Object)rowB, (Object)document.getRow(1));
    }

    public void testReadCSVDocumentDiscriminatorsAreEscaped() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        String rowAcolB = "rowAcolB";
        Object rowA = new Object();
        Mock mockReader = this.mock(CSVLineReader.class);
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowA));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(0), this.eq(rowAcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(1), this.eq(rowAcolB)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowA));
        mockReader.expects(this.once()).method("endData");
        String source = fieldWrapper + rowAcolA + fieldWrapper + discriminator + rowAcolB + lineSeperator;
        StringReader reader = new StringReader(source);
        GoodCsvDocument document = new GoodCsvDocument(null, (CSVLineReader)mockReader.proxy());
        document.read((Reader)reader);
        CreateCSVDocumentTest.assertEquals((String)"number of rows", (int)1, (int)document.getNumberOfRows());
        CreateCSVDocumentTest.assertEquals((String)"first row", (Object)rowA, (Object)document.getRow(0));
    }

    public void testReadCSVDocumentCanHandleNull() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        String rowAcolB = "";
        String rowAcolC = "rowAcolC";
        Object rowA = new Object();
        Mock mockReader = this.mock(CSVLineReader.class);
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowA));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(0), this.eq(rowAcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(1), this.eq(rowAcolB)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(2), this.eq(rowAcolC)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowA));
        mockReader.expects(this.once()).method("endData");
        String source = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + rowAcolB + fieldWrapper + discriminator + fieldWrapper + rowAcolC + fieldWrapper + lineSeperator;
        StringReader reader = new StringReader(source);
        GoodCsvDocument document = new GoodCsvDocument(null, (CSVLineReader)mockReader.proxy());
        document.read((Reader)reader);
        CreateCSVDocumentTest.assertEquals((String)"number of rows", (int)1, (int)document.getNumberOfRows());
        CreateCSVDocumentTest.assertEquals((String)"first row", (Object)rowA, (Object)document.getRow(0));
    }

    public void testGoodCreateCSVDocumentWriterIsCalled() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        String rowAcolB = "rowAcolB";
        String rowBcolA = "rowBcolA";
        String rowBcolB = "rowBcolB";
        Object rowA = new Object();
        Object rowB = new Object();
        Mock mockWriter = this.mock(CSVLineWriter.class);
        mockWriter.expects(this.once()).method("getNoOfColumns").with((Constraint)this.eq(rowA)).will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(0)).will(this.returnValue(rowAcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(1)).will(this.returnValue(rowAcolB));
        mockWriter.expects(this.once()).method("getNoOfColumns").with((Constraint)this.eq(rowB)).will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowB), (Constraint)this.eq(0)).will(this.returnValue(rowBcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowB), (Constraint)this.eq(1)).will(this.returnValue(rowBcolB));
        StringWriter writer = new StringWriter();
        GoodCsvDocument document = new GoodCsvDocument((CSVLineWriter)mockWriter.proxy(), null);
        document.addLine(rowA);
        document.addLine(rowB);
        document.write((Writer)writer);
        String s = writer.toString();
        String expectedString = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + rowAcolB + fieldWrapper + lineSeperator;
        expectedString = expectedString + fieldWrapper + rowBcolA + fieldWrapper + discriminator + fieldWrapper + rowBcolB + fieldWrapper + lineSeperator;
        CreateCSVDocumentTest.assertEquals((String)expectedString, (String)s);
    }

    public void testGoodCreateCSVDocumentWriterHandlesNull() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        Object rowAcolB = null;
        Object rowA = new Object();
        Mock mockWriter = this.mock(CSVLineWriter.class);
        mockWriter.expects(this.once()).method("getNoOfColumns").with((Constraint)this.eq(rowA)).will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(0)).will(this.returnValue(rowAcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(1)).will(this.returnValue(rowAcolB));
        StringWriter writer = new StringWriter();
        GoodCsvDocument document = new GoodCsvDocument((CSVLineWriter)mockWriter.proxy(), null);
        document.addLine(rowA);
        document.write((Writer)writer);
        String s = writer.toString();
        String expectedString = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + "" + fieldWrapper + lineSeperator;
        CreateCSVDocumentTest.assertEquals((String)expectedString, (String)s);
    }

    public void testGoodCreateCSVDocumentDiscriminatorsAreEscaped() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowA" + discriminator + "colA";
        String rowAcolB = "rowAcolB";
        Object rowA = new Object();
        Mock mockWriter = this.mock(CSVLineWriter.class);
        mockWriter.expects(this.once()).method("getNoOfColumns").will(this.returnValue(2));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(0)).will(this.returnValue(rowAcolA));
        mockWriter.expects(this.once()).method("getColumn").with((Constraint)this.eq(rowA), (Constraint)this.eq(1)).will(this.returnValue(rowAcolB));
        StringWriter writer = new StringWriter();
        GoodCsvDocument document = new GoodCsvDocument((CSVLineWriter)mockWriter.proxy(), null);
        document.addLine(rowA);
        document.write((Writer)writer);
        String s = writer.toString();
        String expectedString = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + rowAcolB + fieldWrapper + lineSeperator;
        CreateCSVDocumentTest.assertEquals((String)expectedString, (String)s);
    }

    public void testGoodReadCSVDocumentReaderIsCalled() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String rowAcolA = "rowAcolA";
        String rowAcolB = "rowAcolB";
        String rowBcolA = "rowBcolA";
        String rowBcolB = "rowBcolB";
        Object rowA = new Object();
        Object rowB = new Object();
        Mock mockReader = this.mock(CSVLineReader.class);
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowB));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowB), this.eq(0), this.eq(rowBcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowB), this.eq(1), this.eq(rowBcolB)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowB));
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowA));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(0), this.eq(rowAcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(1), this.eq(rowAcolB)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowA));
        mockReader.expects(this.atLeastOnce()).method("endData");
        String source = rowAcolA + discriminator + rowAcolB + lineSeperator;
        source = source + rowBcolA + discriminator + rowBcolB + lineSeperator;
        StringReader reader = new StringReader(source);
        GoodCsvDocument document = new GoodCsvDocument(null, (CSVLineReader)mockReader.proxy());
        document.read((Reader)reader);
        CreateCSVDocumentTest.assertEquals((String)"number of rows", (int)2, (int)document.getNumberOfRows());
        CreateCSVDocumentTest.assertEquals((String)"first row", (Object)rowA, (Object)document.getRow(0));
        CreateCSVDocumentTest.assertEquals((String)"second row", (Object)rowB, (Object)document.getRow(1));
    }

    public void testGoodReadCSVDocumentDiscriminatorsAreEscaped() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        String rowAcolB = "rowAcolB";
        Object rowA = new Object();
        Mock mockReader = this.mock(CSVLineReader.class);
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowA));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(0), this.eq(rowAcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(1), this.eq(rowAcolB)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowA));
        mockReader.expects(this.once()).method("endData");
        String source = fieldWrapper + rowAcolA + fieldWrapper + discriminator + rowAcolB + lineSeperator;
        StringReader reader = new StringReader(source);
        GoodCsvDocument document = new GoodCsvDocument(null, (CSVLineReader)mockReader.proxy());
        document.read((Reader)reader);
        CreateCSVDocumentTest.assertEquals((String)"number of rows", (int)1, (int)document.getNumberOfRows());
        CreateCSVDocumentTest.assertEquals((String)"first row", (Object)rowA, (Object)document.getRow(0));
    }

    public void testReadGoodCSVDocumentCanHandleNull() throws Exception {
        String discriminator = ",";
        String lineSeperator = System.getProperty("line.separator");
        String fieldWrapper = "\"";
        String rowAcolA = "rowAcolA";
        String rowAcolB = "";
        String rowAcolC = "rowAcolC";
        Object rowA = new Object();
        Mock mockReader = this.mock(CSVLineReader.class);
        mockReader.expects(this.once()).method("constructNewObject").will(this.returnValue(rowA));
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(0), this.eq(rowAcolA)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(1), this.eq(rowAcolB)});
        mockReader.expects(this.once()).method("setColumn").with(new Constraint[]{this.eq(rowA), this.eq(2), this.eq(rowAcolC)});
        mockReader.expects(this.once()).method("end").with((Constraint)this.eq(rowA));
        mockReader.expects(this.once()).method("endData");
        String source = fieldWrapper + rowAcolA + fieldWrapper + discriminator + fieldWrapper + rowAcolB + fieldWrapper + discriminator + fieldWrapper + rowAcolC + fieldWrapper + lineSeperator;
        StringReader reader = new StringReader(source);
        GoodCsvDocument document = new GoodCsvDocument(null, (CSVLineReader)mockReader.proxy());
        document.read((Reader)reader);
        CreateCSVDocumentTest.assertEquals((String)"number of rows", (int)1, (int)document.getNumberOfRows());
        CreateCSVDocumentTest.assertEquals((String)"first row", (Object)rowA, (Object)document.getRow(0));
    }
}

