/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.io.File;
import java.io.IOException;
import uk.ac.warwick.util.AbstractFileBasedTest;
import uk.ac.warwick.util.core.spring.FileUtils;

public final class FileUtilsDeleteTest
extends AbstractFileBasedTest {
    public void testDeleteFile() throws IOException {
        File fileToDelete = new File(this.root.getParentFile(), "fileToDelete");
        if (!fileToDelete.createNewFile()) {
            FileUtilsDeleteTest.fail((String)("cannot create " + fileToDelete));
        }
        FileUtils.recursiveDelete((File)fileToDelete);
        FileUtilsDeleteTest.assertFalse((String)"file exists", (boolean)fileToDelete.exists());
    }

    public void testDeleteEmptyDir() throws IOException {
        File dirToDelete = new File(this.root.getParentFile(), "dirToDelete");
        if (!dirToDelete.mkdir()) {
            FileUtilsDeleteTest.fail((String)("cannot create directory " + dirToDelete));
        }
        FileUtils.recursiveDelete((File)dirToDelete);
        FileUtilsDeleteTest.assertFalse((String)"dir exists", (boolean)dirToDelete.exists());
    }

    public void testDeleteDirectoryWithEmptyDirectory() throws IOException {
        File nestedDirToDelete;
        File dirToDelete = new File(this.root.getParentFile(), "dirToDelete");
        if (!dirToDelete.mkdir()) {
            FileUtilsDeleteTest.fail((String)("cannot create directory " + dirToDelete));
        }
        if (!(nestedDirToDelete = new File(dirToDelete, "nestedDir")).mkdir()) {
            FileUtilsDeleteTest.fail((String)("cannot create directory " + nestedDirToDelete));
        }
        FileUtils.recursiveDelete((File)dirToDelete);
        FileUtilsDeleteTest.assertFalse((String)"dir exists", (boolean)dirToDelete.exists());
        FileUtilsDeleteTest.assertFalse((String)"nested dir exists", (boolean)nestedDirToDelete.exists());
    }

    public void testDeleteDirectoryWithDirectoryAndFile() throws IOException {
        File nestedFileToDelete;
        File nestedDirToDelete;
        File dirToDelete = new File(this.root.getParentFile(), "dirToDelete");
        if (!dirToDelete.mkdir()) {
            FileUtilsDeleteTest.fail((String)("cannot create directory " + dirToDelete));
        }
        if (!(nestedDirToDelete = new File(dirToDelete, "nestedDir")).mkdir()) {
            FileUtilsDeleteTest.fail((String)("cannot create directory " + nestedDirToDelete));
        }
        if (!(nestedFileToDelete = new File(dirToDelete, "nestedFile")).createNewFile()) {
            FileUtilsDeleteTest.fail((String)("cannot create directory " + nestedFileToDelete));
        }
        FileUtils.recursiveDelete((File)dirToDelete);
        FileUtilsDeleteTest.assertFalse((String)"dir exists", (boolean)dirToDelete.exists());
        FileUtilsDeleteTest.assertFalse((String)"nested dir exists", (boolean)nestedDirToDelete.exists());
        FileUtilsDeleteTest.assertFalse((String)"nested file exists", (boolean)nestedFileToDelete.exists());
    }
}

