/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.AbstractFileBasedTest;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.core.spring.FileUtils;

public final class FileUtilsCopyTest
extends AbstractFileBasedTest {
    public void testCopyFile() throws IOException {
        File fileToCopy = new File(this.root, "fileToCopy");
        if (!fileToCopy.createNewFile()) {
            FileUtilsCopyTest.fail((String)("cannot create " + fileToCopy));
        }
        FileCopyUtils.copy((byte[])StringUtils.create((String)"contents of file"), (File)fileToCopy);
        File target = new File(this.root, "newFile");
        FileUtils.copy((File)fileToCopy, (File)target, (boolean)true);
        FileUtilsCopyTest.assertTrue((String)"file exists", (boolean)target.exists());
        FileUtilsCopyTest.assertTrue((String)"file is a file", (boolean)target.isFile());
        String sourceContents = new String(FileCopyUtils.copyToByteArray((File)fileToCopy));
        String targetContents = new String(FileCopyUtils.copyToByteArray((File)target));
        FileUtilsCopyTest.assertEquals((String)sourceContents, (String)targetContents);
    }

    public void testCopyEmptyDir() throws IOException {
        File dirToCopy = new File(this.root, "dirToCopy");
        if (!dirToCopy.mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + dirToCopy));
        }
        File target = new File(this.root, "newDir");
        FileUtils.copy((File)dirToCopy, (File)target, (boolean)true);
        FileUtilsCopyTest.assertTrue((String)"dir exists", (boolean)target.exists());
        FileUtilsCopyTest.assertTrue((String)"file is a dir", (boolean)target.isDirectory());
    }

    public void testCopyDirectoryWithEmptyDirectory() throws IOException {
        File nestedDirToCopy;
        File dirToCopy = new File(this.root, "dirToCopy");
        if (!dirToCopy.mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + dirToCopy));
        }
        if (!(nestedDirToCopy = new File(this.root, "dirToCopy/nestedDir")).mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + nestedDirToCopy));
        }
        File target = new File(this.root, "target");
        FileUtils.copy((File)dirToCopy, (File)target, (boolean)true);
        FileUtilsCopyTest.assertTrue((String)"dir exists", (boolean)target.exists());
        FileUtilsCopyTest.assertTrue((String)"file is a dir", (boolean)target.isDirectory());
        File newNestedDir = new File(target, nestedDirToCopy.getName());
        FileUtilsCopyTest.assertTrue((String)"nested dir is dir", (boolean)newNestedDir.isDirectory());
        FileUtilsCopyTest.assertTrue((String)"nested dir exists", (boolean)newNestedDir.exists());
    }

    public void testCopyDirectoryWithEmptyDirectoryButNotRecursive() {
    }

    public void testCopyDirectoryWithDirectoryAndFile() throws IOException {
        File nestedFileToCopy;
        File nestedDirToCopy;
        File dirToCopy = new File(this.root, "dirToCopy");
        if (!dirToCopy.mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + dirToCopy));
        }
        if (!(nestedDirToCopy = new File(dirToCopy, "nestedDir")).mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + nestedDirToCopy));
        }
        if (!(nestedFileToCopy = new File(dirToCopy, "nestedFile")).createNewFile()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + nestedFileToCopy));
        }
        FileCopyUtils.copy((byte[])StringUtils.create((String)"contents of file"), (File)nestedFileToCopy);
        File target = new File(this.root, "target");
        FileUtils.copy((File)dirToCopy, (File)target, (boolean)true);
        FileUtilsCopyTest.assertTrue((String)"dir exists", (boolean)target.exists());
        FileUtilsCopyTest.assertTrue((String)"file is a dir", (boolean)target.isDirectory());
        File newNestedDir = new File(target, nestedDirToCopy.getName());
        FileUtilsCopyTest.assertTrue((String)"nested dir is dir", (boolean)newNestedDir.isDirectory());
        FileUtilsCopyTest.assertTrue((String)"nested dir exists", (boolean)newNestedDir.exists());
        File newNestedFile = new File(target, nestedFileToCopy.getName());
        String sourceContents = new String(FileCopyUtils.copyToByteArray((File)nestedFileToCopy));
        String targetContents = new String(FileCopyUtils.copyToByteArray((File)newNestedFile));
        FileUtilsCopyTest.assertEquals((String)sourceContents, (String)targetContents);
    }

    public void testCopyDirectoryWithDirectoryAndFileButNotRecursive() throws IOException {
        File nestedFileToCopy;
        File nestedDirNotToCopy;
        File dirToCopy = new File(this.root, "dirToCopy");
        if (!dirToCopy.mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + dirToCopy));
        }
        if (!(nestedDirNotToCopy = new File(dirToCopy, "nestedDir")).mkdir()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + nestedDirNotToCopy));
        }
        if (!(nestedFileToCopy = new File(dirToCopy, "nestedFile")).createNewFile()) {
            FileUtilsCopyTest.fail((String)("cannot create directory " + nestedFileToCopy));
        }
        FileCopyUtils.copy((byte[])StringUtils.create((String)"contents of file"), (File)nestedFileToCopy);
        File target = new File(this.root, "target");
        FileUtils.copy((File)dirToCopy, (File)target, (boolean)false);
        FileUtilsCopyTest.assertTrue((String)"dir exists", (boolean)target.exists());
        FileUtilsCopyTest.assertTrue((String)"file is a dir", (boolean)target.isDirectory());
        File newNestedDir = new File(target, nestedDirNotToCopy.getName());
        FileUtilsCopyTest.assertFalse((String)"nested dir should not exist", (boolean)newNestedDir.exists());
        File newNestedFile = new File(target, nestedFileToCopy.getName());
        String sourceContents = new String(FileCopyUtils.copyToByteArray((File)nestedFileToCopy));
        String targetContents = new String(FileCopyUtils.copyToByteArray((File)newNestedFile));
        FileUtilsCopyTest.assertEquals((String)sourceContents, (String)targetContents);
    }
}

