/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import junit.framework.TestCase;
import uk.ac.warwick.util.core.spring.FileUtils;

public class FileUtilsConvertToSafeFileNameTest
extends TestCase {
    public void testBadCharacters() {
        String[] goodNames = new String[]{"a.gfd", "abc_-012a.abf"};
        String[] badNames = new String[]{"(", ")", "{", "}", ">", "<", "!", "\"", "$", "%", "^", "&", "*", "+", "=", "[", "]", ":", ";", "@", "'", "~", "#", "?", "/", "|"};
        for (String good : goodNames) {
            FileUtilsConvertToSafeFileNameTest.assertEquals((String)("good: " + good), (String)good, (String)FileUtils.convertToSafeFileName((String)good));
        }
        for (String bad : badNames) {
            FileUtilsConvertToSafeFileNameTest.assertEquals((String)("bad: " + bad), (String)"", (String)FileUtils.convertToSafeFileName((String)bad));
        }
        for (String good : goodNames) {
            for (String bad : badNames) {
                String s = bad + good + bad;
                FileUtilsConvertToSafeFileNameTest.assertEquals((String)("goodAndBad: " + s), (String)good, (String)FileUtils.convertToSafeFileName((String)s));
            }
        }
    }

    public void testMoreThanOneExtension() {
        String fileName = "ab.c.def";
        String badFileName = ".ab.c.def";
        FileUtilsConvertToSafeFileNameTest.assertEquals((String)fileName, (String)FileUtils.convertToSafeFileName((String)badFileName));
    }

    public void testBadExtension() {
        String fileName = "abc.";
        String badFileName = fileName + ")))";
        FileUtilsConvertToSafeFileNameTest.assertEquals((String)fileName, (String)FileUtils.convertToSafeFileName((String)badFileName));
    }

    public void testSpacesAreConverted() {
        String badFileName = "a space.tx t";
        String goodFileName = "a_space.tx_t";
        FileUtilsConvertToSafeFileNameTest.assertEquals((String)goodFileName, (String)FileUtils.convertToSafeFileName((String)badFileName));
    }

    public void testLowerCaseConverting() {
        String badFileName = "ABCde.GiF";
        String goodFileName = "abcde.gif";
        FileUtilsConvertToSafeFileNameTest.assertEquals((String)goodFileName, (String)FileUtils.convertToSafeFileName((String)badFileName));
    }

    public void testPathIsExtracted() {
        String fileName = "abc.def";
        String badFileName = "/gjhsd/sd/abc.def";
        FileUtilsConvertToSafeFileNameTest.assertEquals((String)fileName, (String)FileUtils.convertToSafeFileName((String)badFileName));
    }

    public void testLowerAndSpecial() {
        String fileName = "hello_world";
        String badFileName = "Hello?!?!_%world";
        FileUtilsConvertToSafeFileNameTest.assertEquals((String)fileName, (String)FileUtils.convertToSafeFileName((String)badFileName));
    }
}

