/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup.departments;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.core.lookup.departments.Department;
import uk.ac.warwick.util.core.lookup.departments.DepartmentLookupImpl;
import uk.ac.warwick.util.core.lookup.departments.Faculty;

public class DepartmentLookupTest {
    private DepartmentLookupImpl departmentLookup;

    @Before
    public void setUp() {
        this.departmentLookup = new DepartmentLookupImpl("https://departments.warwick.ac.uk/public/api/department.json", "https://departments.warwick.ac.uk/public/api/faculty.json");
    }

    @Test
    public void testGetDepartment() throws Exception {
        Department department = this.departmentLookup.getDepartment("IN");
        Assert.assertEquals((Object)"IN", (Object)department.getCode());
        Assert.assertEquals((Object)"Information & Digital", (Object)department.getName());
        Assert.assertEquals((Object)"Information & Digital", (Object)department.getShortName());
        Assert.assertEquals((Object)true, (Object)department.isCurrent());
        Assert.assertEquals((Object)"SERVICE", (Object)department.getType());
        Assert.assertNotNull((Object)department.getLastModified());
        Faculty f = department.getFaculty();
        Assert.assertEquals((Object)"X", (Object)f.getCode());
        Assert.assertEquals((Object)"Administration and Service", (Object)f.getName());
        Assert.assertEquals((Object)true, (Object)f.isCurrent());
        Assert.assertNotNull((Object)f.getLastModified());
    }

    @Test
    public void testGetNonExistentDepartment() throws Exception {
        Department department = this.departmentLookup.getDepartment("XYZ");
        Assert.assertNull((Object)department);
    }

    @Test
    public void testGetNameForDepartmentCode() throws Exception {
        String name = this.departmentLookup.getNameForDepartmentCode("IN");
        Assert.assertEquals((Object)"Information & Digital", (Object)name);
    }

    @Test
    public void testGetNameForNonExistentDepartmentCode() throws Exception {
        String name = this.departmentLookup.getNameForDepartmentCode("XYZ");
        Assert.assertNull((Object)name);
    }

    @Test
    public void testGetNullDepartment() throws Exception {
        Department department = this.departmentLookup.getDepartment(null);
        Assert.assertNull((Object)department);
    }

    @Test
    public void testGetAllDepartments() throws Exception {
        List allDepartments = this.departmentLookup.getAllDepartments();
        Assert.assertFalse((boolean)allDepartments.isEmpty());
        Department lastDepartment = null;
        for (Department department : allDepartments) {
            if (lastDepartment != null) {
                Assert.assertTrue((lastDepartment.compareTo(department) <= 0 ? 1 : 0) != 0);
            }
            lastDepartment = department;
        }
    }

    private void checkTypes(Set<Department> filteredDepartments, String type) {
        Assert.assertFalse((boolean)filteredDepartments.isEmpty());
        for (Department department : filteredDepartments) {
            Assert.assertTrue((boolean)department.getType().equals(type));
        }
    }

    @Test
    public void testFilteredDepartments() throws Exception {
        this.checkTypes(this.departmentLookup.getAllAcademicDepartments(), "ACADEMIC");
        this.checkTypes(this.departmentLookup.getAllServiceDepartments(), "SERVICE");
        this.checkTypes(this.departmentLookup.getAllAdminDepartments(), "RESERVED");
        this.checkTypes(this.departmentLookup.getAllSelfFundingDepartments(), "SELF_FINANCING");
    }

    @Test
    public void testGetDepartmentWithBadSource() throws Exception {
        this.departmentLookup = new DepartmentLookupImpl("https://websignon-test.warwick.ac.uk/department.json", "");
        this.departmentLookup.clearCache();
        Assert.assertNull((Object)this.departmentLookup.getDepartment("IN"));
        Assert.assertNull((Object)this.departmentLookup.getAllDepartments());
    }
}

