/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import uk.ac.warwick.util.core.StringUtils;

public final class StringUtilsListToStringConversionTest
extends TestCase {
    public void testEmptyKeywordToString() {
        String seperator = " ";
        String result = StringUtils.convertToString((Collection)Collections.EMPTY_LIST, (String)seperator);
        StringUtilsListToStringConversionTest.assertEquals((String)"", (String)result);
    }

    public void testConvertSingleKeywordToString() {
        String keyword = " the_keyword ";
        String seperator = " ";
        String result = StringUtils.convertToString(Collections.singletonList(keyword), (String)seperator);
        StringUtilsListToStringConversionTest.assertEquals((String)"trimmed single result", (String)keyword.trim(), (String)result);
    }

    public void testConvertMultipleKeywordsToString() {
        String firstKeyword = "firstKeyword";
        String secondKeyword = "secondKeyword";
        String seperator = ", ";
        List<String> keywords = Arrays.asList(firstKeyword, secondKeyword);
        String result = StringUtils.convertToString(keywords, (String)seperator);
        StringUtilsListToStringConversionTest.assertEquals((String)"multiple trimmed result", (String)(firstKeyword.trim() + seperator + secondKeyword), (String)result);
    }

    public void testConvertEmptyKeywordToList() {
        List results = StringUtils.convertCommaDelimitedStringToList(null);
        StringUtilsListToStringConversionTest.assertEquals((String)"number of results", (int)0, (int)results.size());
    }

    public void testConvertSingleKeywordToList() {
        String keyword = " the_keyword ";
        List results = StringUtils.convertCommaDelimitedStringToList((String)keyword);
        StringUtilsListToStringConversionTest.assertEquals((String)"number of results", (int)1, (int)results.size());
        StringUtilsListToStringConversionTest.assertEquals((String)"result", (String)keyword.trim(), (String)((String)results.get(0)));
    }

    public void testConvertMultipleCommaSeperatedKeywordToList() {
        String firstKeyword = " the_keyword ";
        String secondKeyword = " the_second_keyword";
        String keywords = firstKeyword + "," + secondKeyword;
        List results = StringUtils.convertCommaDelimitedStringToList((String)keywords);
        StringUtilsListToStringConversionTest.assertEquals((String)"number of results", (int)2, (int)results.size());
        StringUtilsListToStringConversionTest.assertEquals((String)"first result", (String)firstKeyword.trim(), (String)((String)results.get(0)));
        StringUtilsListToStringConversionTest.assertEquals((String)"second result", (String)secondKeyword.trim(), (String)((String)results.get(1)));
    }

    public void testConvertMultipleCommaSeperatedKeywordToListButIgnoreMultipleCommas() {
        String firstKeyword = " the_keyword ";
        String secondKeyword = " the_second_keyword";
        String keywords = firstKeyword + ",,,,,," + secondKeyword;
        List results = StringUtils.convertCommaDelimitedStringToList((String)keywords);
        StringUtilsListToStringConversionTest.assertEquals((String)"number of results", (int)2, (int)results.size());
        StringUtilsListToStringConversionTest.assertEquals((String)"first result", (String)firstKeyword.trim(), (String)((String)results.get(0)));
        StringUtilsListToStringConversionTest.assertEquals((String)"second result", (String)secondKeyword.trim(), (String)((String)results.get(1)));
    }

    public void testConvertCommaSeperatedKeywordToListButIgnoreEscapedCommas() {
        String firstKeyword = "\\, \\ the_keyword\\, happenstance \\, withoutdoubt \\ ";
        String secondKeyword = " the_second_keyword";
        String keywords = firstKeyword + "," + secondKeyword;
        List results = StringUtils.convertUnescapedCommaDelimitedStringToList((String)keywords);
        StringUtilsListToStringConversionTest.assertEquals((String)"number of results", (int)2, (int)results.size());
        StringUtilsListToStringConversionTest.assertEquals((String)"first result", (String)firstKeyword.replace("\\,", ",").trim(), (String)((String)results.get(0)));
        StringUtilsListToStringConversionTest.assertEquals((String)"second result", (String)secondKeyword.trim(), (String)((String)results.get(1)));
    }
}

