/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.springframework.web.util.NestedServletException;
import uk.ac.warwick.util.core.ExceptionUtils;

public class ExceptionUtilsTest
extends TestCase {
    public void testTopException() {
        UnsupportedOperationException e = new UnsupportedOperationException("hello");
        ExceptionUtilsTest.assertEquals((Object)e, (Object)ExceptionUtils.getInterestingThrowable((Throwable)e, (Class[])new Class[]{ServletException.class}));
    }

    public void testLowerException() {
        RuntimeException re = new RuntimeException("Honk!");
        UnsupportedOperationException e = new UnsupportedOperationException("hello", re);
        ExceptionUtilsTest.assertEquals((Object)e, (Object)ExceptionUtils.getInterestingThrowable((Throwable)e, (Class[])new Class[]{ServletException.class}));
    }

    public void testIgnorableException() {
        RuntimeException re = new RuntimeException("Honk!");
        UnsupportedOperationException e = new UnsupportedOperationException("hello", re);
        ExceptionUtilsTest.assertEquals((Object)re, (Object)ExceptionUtils.getInterestingThrowable((Throwable)e, (Class[])new Class[]{UnsupportedOperationException.class}));
    }

    public void testServletRootCause() {
        UnsupportedOperationException e = new UnsupportedOperationException("hello");
        NestedServletException se = new NestedServletException("Terrible", (Throwable)e);
        ExceptionUtilsTest.assertEquals((Object)e, (Object)ExceptionUtils.getInterestingThrowable((Throwable)se, (Class[])new Class[]{ServletException.class}));
    }
}

