/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.content.texttransformers.AbstractSquareTagTransformer;

public final class SquareTagTransformerTest {
    @Test
    public void extractHeadsNoHeads() throws Exception {
        ArrayList heads = Lists.newArrayList();
        String output = AbstractSquareTagTransformer.extractHeads((String)"Here is some random text", (List)heads);
        Assert.assertEquals((Object)"Here is some random text", (Object)output);
        Assert.assertTrue((boolean)heads.isEmpty());
    }

    @Test
    public void extractHeadsOneHead() throws Exception {
        ArrayList heads = Lists.newArrayList();
        String output = AbstractSquareTagTransformer.extractHeads((String)"<p>Here is some random text.</p>\n\n<head><script></script></head>", (List)heads);
        Assert.assertEquals((Object)"<p>Here is some random text.</p>", (Object)output);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"<script></script>"}), (Object)heads);
    }

    @Test
    public void extractHeadsTwoHeads() throws Exception {
        ArrayList heads = Lists.newArrayList();
        String output = AbstractSquareTagTransformer.extractHeads((String)"<head><style>css</style></head>\n\n<p>Here is some random text.</p>\n\n<head><script></script></head>", (List)heads);
        Assert.assertEquals((Object)"<p>Here is some random text.</p>", (Object)output);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"<style>css</style>", "<script></script>"}), (Object)heads);
    }
}

