/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import junit.framework.TestCase;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.NewWindowLinkTextTransformer;
import uk.ac.warwick.util.content.texttransformers.TagTransformer;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;

public final class NewWindowLinkTextTransformerTest
extends TestCase {
    String image = "<img class='targetBlank' alt='' title='Link opens in a new window' src='/static_war/images/shim.gif' />";

    public void testTagTransformerDoNothing() {
        String input = "Test abc <a href='abc' target=\"_blank\">Link</a> xyz";
        TagTransformer transformer = new TagTransformer("a", new TextPatternTransformer.Callback(){

            public String transform(String i, MutableContent mc) {
                return i;
            }
        }, false);
        String result = transformer.apply(new MutableContent(null, input)).getContent();
        NewWindowLinkTextTransformerTest.assertEquals((String)input, (String)result);
    }

    public void testTagTransformerReplaceText() {
        String input = "Test abc <a href='abc' target=\"_blank\">Link</a> xyz";
        String expected = "Test abc REPLACE xyz";
        TagTransformer transformer = new TagTransformer("a", new TextPatternTransformer.Callback(){

            public String transform(String i, MutableContent mc) {
                return "REPLACE";
            }
        }, false);
        String result = transformer.apply(new MutableContent(null, input)).getContent();
        NewWindowLinkTextTransformerTest.assertEquals((String)expected, (String)result);
    }

    public void testTagTransformerSurroundText() {
        String input = "Test abc <a href='abc' target=\"_blank\">Link</a> xyz";
        String expected = "Test abc START<a href='abc' target=\"_blank\">Link</a>END xyz";
        TagTransformer transformer = new TagTransformer("a", new TextPatternTransformer.Callback(){

            public String transform(String i, MutableContent mc) {
                return "START" + i + "END";
            }
        }, false);
        String result = transformer.apply(new MutableContent(null, input)).getContent();
        NewWindowLinkTextTransformerTest.assertEquals((String)expected, (String)result);
    }

    public void testTagTransformerUppercase() {
        String input = "Test abc <a href='abc' target=\"_blank\">Link</a> xyz";
        String expected = "Test abc <A HREF='ABC' TARGET=\"_BLANK\">LINK</A> xyz";
        TagTransformer transformer = new TagTransformer("a", new TextPatternTransformer.Callback(){

            public String transform(String i, MutableContent mc) {
                return i.toUpperCase();
            }
        }, false);
        String result = transformer.apply(new MutableContent(null, input)).getContent();
        NewWindowLinkTextTransformerTest.assertEquals((String)expected, (String)result);
    }

    public void testBasicRewrite() {
        String input = "Text text <a href=\"something\" target=\"_blank\">Link</a>";
        String expected = "Text text <a href=\"something\" target=\"_blank\">Link" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testTwoLinks() {
        String input = "Text text <a href=\"something\" target=\"_blank\">Link</a> and <a href=\"somethingelse\" target=\"_blank\">Another Link</a>";
        String expected = "Text text <a href=\"something\" target=\"_blank\">Link" + this.image + "</a> and <a href=\"somethingelse\" target=\"_blank\">Another Link" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testSingleQuotes() {
        String input = "Text text <a href='something' target='_blank'>Link</a>";
        String expected = "Text text <a href='something' target='_blank'>Link" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testTagsInLink() {
        String input = "Text text <a href='something' target='_blank'>Link with <strong>tags</strong> in it</a>";
        String expected = "Text text <a href='something' target='_blank'>Link with <strong>tags</strong> in it" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testParticularTagsInLink() {
        String input = "<a href=\"http://www2.warwick.ac.uk\" target=\"_blank\"><strong>Warwick home page</strong></a>";
        String expected = "<a href=\"http://www2.warwick.ac.uk\" target=\"_blank\"><strong>Warwick home page</strong>" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testNewlinesInCaption() {
        String input = "<a href=\"http://www2.warwick.ac.uk\" target=\"_blank\">Warwick \nhome page</a>";
        String expected = "<a href=\"http://www2.warwick.ac.uk\" target=\"_blank\">Warwick \nhome page" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testNewLinesInTag() {
        String input = "<a href=\"http://www2.warwick.ac.uk\" \n target=\"_blank\">Warwick home page</a>";
        String expected = "<a href=\"http://www2.warwick.ac.uk\" \n target=\"_blank\">Warwick home page" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testVaryCaseTags() {
        String input = "Text text <A Href=\"something\" TARGET=\"_Blank\">Link</a>";
        String expected = "Text text <A Href=\"something\" TARGET=\"_Blank\">Link" + this.image + "</a>";
        this.verify(input, expected);
    }

    public void testEmptyLink() {
        String input = "Text test <a>Blah</a>";
        this.verify(input, input);
    }

    private void verify(String input, String expected) {
        NewWindowLinkTextTransformer parser = new NewWindowLinkTextTransformer();
        NewWindowLinkTextTransformerTest.assertEquals((String)expected, (String)parser.apply(new MutableContent(null, input)).getContent());
    }
}

