/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.CssUrlRewriteTransformer;

public class CssUrlRewriteTransformerTest {
    @Test
    public void rewriting() throws Exception {
        CssUrlRewriteTransformer transformer = new CssUrlRewriteTransformer("http://www2.warwick.ac.uk/services/its/");
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("style.css");
        Assert.assertNotNull((String)"file not foond", (Object)resource);
        String content = FileCopyUtils.copyToString((Reader)new InputStreamReader(resource, StandardCharsets.UTF_8));
        String result = transformer.apply(new MutableContent(null, content)).getContent();
        System.out.println(result);
        Assert.assertTrue((String)"unquoted", (boolean)result.contains("url(http://www2.warwick.ac.uk/services/fab.gif)"));
        Assert.assertTrue((String)"quoted", (boolean)result.contains("url(http://www2.warwick.ac.uk/services/its/ab/doozy.png)"));
        Assert.assertTrue((String)"absolute", (boolean)result.contains("background-image: url(http://www.example.com/fensler.jpg);"));
    }
}

