/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.AbstractHtmlCleanerTest;
import uk.ac.warwick.util.content.cleaner.Cleaner;
import uk.ac.warwick.util.content.texttransformers.BodyCleanupHtmlTransformer;

public final class BodyCleanupHtmlTransformerTest
extends AbstractHtmlCleanerTest {
    private BodyCleanupHtmlTransformer transformer;

    @Before
    public void setUp() {
        this.transformer = new BodyCleanupHtmlTransformer((Cleaner)this.cleaner);
    }

    @Test
    public void transformJustBody() {
        String input = "<html><head>this is left alone <li></head><body><p>Test transform</p><p>Remove <u>underlining</u></body></html>";
        String result = this.transformer.apply(new MutableContent(null, input)).getContent();
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"<html><head>this is left alone <li></head>"));
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<u>")));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"<p>Test transform</p>"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"<p>Remove underlining</p>"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"</body>"));
    }

    @Test
    public void transformAll() {
        String input = "<p>Test transform <ul><li></ul></p><p>Remove <u>underlining</u>";
        String result = this.transformer.apply(new MutableContent(null, input)).getContent();
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<u>")));
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<html>")));
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"</body>")));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"</li>"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"<p>Test transform"));
    }
}

