/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.AbstractSquareTagTransformer;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;

public class AbstractSquareBracketTagTransformerTest
extends TestCase {
    private SquareBracketTransformer transformer;
    private MultiTagSquareBracketTransformer transformer2;
    private BlockLevelSquareBracketTransformer transformer3;

    public void setUp() throws Exception {
        this.transformer = new SquareBracketTransformer();
        this.transformer2 = new MultiTagSquareBracketTransformer();
        this.transformer3 = new BlockLevelSquareBracketTransformer();
    }

    public void disabled_testNesting() throws Exception {
        String input = "[display show=yes]this is [display show=no]not [/display]good.[/display]";
        String expected = "this is good.";
        AbstractSquareTagTransformer t = new AbstractSquareTagTransformer("display"){

            protected TextPatternTransformer.Callback getCallback() {
                return new TextPatternTransformer.Callback(){

                    public String transform(String input, MutableContent mc) {
                        Matcher matcher = this.getTagPattern().matcher(input);
                        TestCase.assertTrue((boolean)matcher.matches());
                        Map params = this.getParameters(matcher);
                        String contents = this.getContents(matcher);
                        if (params.get("show").equals("yes")) {
                            return contents;
                        }
                        return "";
                    }
                };
            }

            protected String[] getAllowedParameters() {
                return new String[]{"show"};
            }

            protected boolean isTagGeneratesHead() {
                return false;
            }
        };
        MutableContent content = t.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)expected, (String)content.getContent());
    }

    public void testStandard() {
        String input = "[tag-name]contents[/tag-name]";
        this.transformer.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"contents", (String)this.transformer.contents);
    }

    public void testAttributes() {
        String input = "[tag-name allowed1=\"one\" allowed2='two' allowed3=three] the contents [/tag-name]";
        this.transformer.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)" the contents ", (String)this.transformer.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer.parameters.containsKey("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer.parameters.containsKey("allowed2"));
        AbstractSquareBracketTagTransformerTest.assertFalse((boolean)this.transformer.parameters.containsKey("allowed3"));
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer.parameters.get("allowed1"), (Object)"one");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer.parameters.get("allowed2"), (Object)"two");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer.parameters.get("allowed3"), null);
    }

    public void testNonBreakingSpaces() {
        String input = "[tag-name allowed1=one&nbsp; allowed2='two']bam[/tag-name]";
        this.transformer.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer.parameters.containsKey("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer.parameters.containsKey("allowed2"));
        AbstractSquareBracketTagTransformerTest.assertEquals((Object)"one", this.transformer.parameters.get("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertEquals((Object)"two", this.transformer.parameters.get("allowed2"));
    }

    public void testEscapedAttributes() {
        String input = "[tag-name regex='^\\[A-Za-z0-9\\]+$']\nSome escaped stuff ^\\[A-Za-z0-9\\]+$\n[/tag-name]";
        this.transformer.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"\nSome escaped stuff ^\\[A-Za-z0-9\\]+$\n", (String)this.transformer.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer.parameters.containsKey("regex"));
        String regex = (String)this.transformer.parameters.get("regex");
        regex = regex.replaceAll("\\\\\\[", "[");
        regex = regex.replaceAll("\\\\]", "]");
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"^[A-Za-z0-9]+$", (String)regex);
        AbstractSquareBracketTagTransformerTest.assertTrue((String)"regex works", (boolean)Pattern.matches(regex, "Sometextwithoutspaces092"));
    }

    public void testStandardMulti() {
        String input = "[tag-name]contents[/tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"contents", (String)this.transformer2.contents);
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"tag-name", (String)this.transformer2.tagName);
        input = "[other-tag-name]contents[/other-tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"contents", (String)this.transformer2.contents);
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"other-tag-name", (String)this.transformer2.tagName);
    }

    public void testDoesntMatchMismatchedTags() {
        String input = "[tag-name]contents[/other-tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertNull((Object)this.transformer2.contents);
    }

    public void testAttributesMulti() {
        String input = "[tag-name allowed1=\"one\" allowed2='two' allowed3=three] the contents [/tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)" the contents ", (String)this.transformer2.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer2.parameters.containsKey("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer2.parameters.containsKey("allowed2"));
        AbstractSquareBracketTagTransformerTest.assertFalse((boolean)this.transformer2.parameters.containsKey("allowed3"));
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer2.parameters.get("allowed1"), (Object)"one");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer2.parameters.get("allowed2"), (Object)"two");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer2.parameters.get("allowed3"), null);
        input = "[other-tag-name allowed1=\"one\" allowed2='two' allowed3=three] the contents [/other-tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)" the contents ", (String)this.transformer2.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer2.parameters.containsKey("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer2.parameters.containsKey("allowed2"));
        AbstractSquareBracketTagTransformerTest.assertFalse((boolean)this.transformer2.parameters.containsKey("allowed3"));
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer2.parameters.get("allowed1"), (Object)"one");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer2.parameters.get("allowed2"), (Object)"two");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer2.parameters.get("allowed3"), null);
    }

    public void testEscapedAttributesMulti() {
        String input = "[tag-name regex='^\\[A-Za-z0-9\\]+$']\nSome escaped stuff ^\\[A-Za-z0-9\\]+$\n[/tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"\nSome escaped stuff ^\\[A-Za-z0-9\\]+$\n", (String)this.transformer2.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer2.parameters.containsKey("regex"));
        String regex = (String)this.transformer2.parameters.get("regex");
        regex = regex.replaceAll("\\\\\\[", "[");
        regex = regex.replaceAll("\\\\]", "]");
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"^[A-Za-z0-9]+$", (String)regex);
        AbstractSquareBracketTagTransformerTest.assertTrue((String)"regex works", (boolean)Pattern.matches(regex, "Sometextwithoutspaces092"));
        input = "[other-tag-name regex='^\\[A-Za-z0-9\\]+$']\nSome escaped stuff ^\\[A-Za-z0-9\\]+$\n[/other-tag-name]";
        this.transformer2.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"\nSome escaped stuff ^\\[A-Za-z0-9\\]+$\n", (String)this.transformer2.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer2.parameters.containsKey("regex"));
        regex = (String)this.transformer2.parameters.get("regex");
        regex = regex.replaceAll("\\\\\\[", "[");
        regex = regex.replaceAll("\\\\]", "]");
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"^[A-Za-z0-9]+$", (String)regex);
        AbstractSquareBracketTagTransformerTest.assertTrue((String)"regex works", (boolean)Pattern.matches(regex, "Sometextwithoutspaces092"));
    }

    public void testBlockStandard() {
        String input = "[tag-name]contents[/tag-name]";
        this.transformer3.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"contents", (String)this.transformer3.contents);
    }

    public void testBlockWrapped() {
        String input = "<p>[tag-name]contents[/tag-name]</p>";
        this.transformer3.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)"<p>contents</p>", (String)this.transformer3.contents);
    }

    public void testBlockAttributes() {
        String input = "[tag-name allowed1=\"one\" allowed2='two' allowed3=three] the contents [/tag-name]";
        this.transformer3.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((String)" the contents ", (String)this.transformer3.contents);
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer3.parameters.containsKey("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertTrue((boolean)this.transformer3.parameters.containsKey("allowed2"));
        AbstractSquareBracketTagTransformerTest.assertFalse((boolean)this.transformer3.parameters.containsKey("allowed3"));
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer3.parameters.get("allowed1"), (Object)"one");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer3.parameters.get("allowed2"), (Object)"two");
        AbstractSquareBracketTagTransformerTest.assertEquals(this.transformer3.parameters.get("allowed3"), null);
    }

    public void testAttributeEscaping() {
        String input = "[tag-name allowed2=\"The \\\"Magic\\\" tag\" allowed1='It\\'s escaped!' ]the contents[/tag-name]";
        this.transformer3.apply(new MutableContent(null, input));
        AbstractSquareBracketTagTransformerTest.assertEquals((Object)"It's escaped!", this.transformer3.parameters.get("allowed1"));
        AbstractSquareBracketTagTransformerTest.assertEquals((Object)"The \"Magic\" tag", this.transformer3.parameters.get("allowed2"));
    }

    private static class BlockLevelSquareBracketTransformer
    extends AbstractSquareTagTransformer {
        private String contents;
        private Map<String, Object> parameters;

        public BlockLevelSquareBracketTransformer() {
            super("tag-name", false, false, true);
        }

        protected String[] getAllowedParameters() {
            return new String[]{"allowed1", "allowed2", "regex"};
        }

        protected boolean isTagGeneratesHead() {
            return false;
        }

        protected TextPatternTransformer.Callback getCallback() {
            return new TextPatternTransformer.Callback(){

                public String transform(String input, MutableContent mc) {
                    Matcher matcher = this.getTagPattern().matcher(input);
                    if (!matcher.matches()) {
                        TestCase.fail((String)"Failed to match tag, but shouldn't be here if it didn't");
                    }
                    parameters = this.getParameters(matcher);
                    contents = this.getContents(matcher);
                    return input;
                }
            };
        }
    }

    private static class MultiTagSquareBracketTransformer
    extends AbstractSquareTagTransformer {
        private String contents;
        private Map<String, Object> parameters;
        private String tagName;

        public MultiTagSquareBracketTransformer() {
            super(new String[]{"tag-name", "other-tag-name"}, true);
        }

        protected String[] getAllowedParameters() {
            return new String[]{"allowed1", "allowed2", "regex"};
        }

        protected boolean isTagGeneratesHead() {
            return false;
        }

        protected TextPatternTransformer.Callback getCallback() {
            return new TextPatternTransformer.Callback(){

                public String transform(String input, MutableContent mc) {
                    Matcher matcher = this.getTagPattern().matcher(input);
                    if (!matcher.matches()) {
                        TestCase.fail((String)"Failed to match tag, but shouldn't be here if it didn't");
                    }
                    parameters = this.getParameters(matcher);
                    contents = this.getContents(matcher);
                    tagName = this.getTagName(matcher);
                    return input;
                }
            };
        }
    }

    private static class SquareBracketTransformer
    extends AbstractSquareTagTransformer {
        private String contents;
        private Map<String, Object> parameters;

        public SquareBracketTransformer() {
            super("tag-name", true);
        }

        protected String[] getAllowedParameters() {
            return new String[]{"allowed1", "allowed2", "regex"};
        }

        protected boolean isTagGeneratesHead() {
            return false;
        }

        protected TextPatternTransformer.Callback getCallback() {
            return new TextPatternTransformer.Callback(){

                public String transform(String input, MutableContent mc) {
                    Matcher matcher = this.getTagPattern().matcher(input);
                    if (!matcher.matches()) {
                        TestCase.fail((String)"Failed to match tag, but shouldn't be here if it didn't");
                    }
                    parameters = this.getParameters(matcher);
                    contents = this.getContents(matcher);
                    return input;
                }
            };
        }
    }
}

