/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.cleaner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.cleaner.AbstractHtmlCleanerTest;

public final class HtmlCleanerTest
extends AbstractHtmlCleanerTest {
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile("[\\t ]+$", 8);

    @Test
    public void sbtwo3795_strikethrough() throws Exception {
        String input = "<html><body>I am afraid of <span style=\"text-decoration: line-through; \" _mce_style=\"text-decoration: line-through;\">ghosts</span>tigers </body></html>";
        String expected = "I am afraid of <strike>ghosts</strike>tigers";
        this.verify(expected, input);
    }

    @Test
    public void sbtwo4909() throws Exception {
        String input = this.readResourceToString("/htmlClean/sbtwo-4909.html");
        this.verify(input, input);
    }

    @Test
    public void sbtwo5135() throws Exception {
        String expected = "<script type=\"text/javascript\">(function() {return true;})();</script>";
        String input = "<script type=\"mce-text/javascript\">(function() {return true;})();</script>";
        this.verify(expected, input);
        input = "<script type=\"mce-mce-mce-mce-text/javascript\">(function() {return true;})();</script>";
        this.verify(expected, input);
    }

    @Test
    public void sbtwo5117() throws Exception {
        String expected = "<div><!-- a comment about some <p> tags -->\n</div>";
        String input = "<div><p><!-- a comment about some <p> tags -->\n</p>\n</div>";
        this.verify(expected, input);
    }

    @Test
    public void basicSanity() throws Exception {
        String input = this.readResourceToString("/htmlClean/input1.html");
        String output = this.cleaner.clean(input, new MutableContent(null, null));
        Assert.assertTrue((String)"keep onclick", (boolean)output.contains("onclick=\"alert('hello, I\\'m an alert')\""));
        Assert.assertTrue((String)"keep align", (boolean)output.contains("align="));
        Assert.assertFalse((String)"remove u", (boolean)output.contains("<u>"));
        Assert.assertFalse((String)"remove font", (boolean)output.contains("<font"));
        Assert.assertFalse((String)"remove font", (boolean)output.contains("</font>"));
        Assert.assertFalse((String)"remove span", (boolean)output.contains("<span>"));
        Assert.assertTrue((String)"Not screwed up script tag contents", (boolean)output.contains("assert(3 < 7);"));
        Assert.assertTrue((String)"don't remove non-empty span", (boolean)output.contains("<span class=\"dontdeleteme\">"));
        Assert.assertTrue((String)"correctly don't delete nested good span", (boolean)output.contains("<span class=\"dontdeleteme\">sub</span>"));
        Assert.assertTrue((String)"map tag tidied", (boolean)output.contains("<map name=\"mymap\">"));
    }

    @Test
    public void spanner() throws Exception {
        String input = "<p class=\"MsoNormal\">A <span style=\"\">&nbsp; </span> B</p>";
        this.verify("<p>A &nbsp; B</p>", input);
    }

    @Test
    public void strongTagsNotNested() {
        String input = "<p><strong>bold <strong>text</strong></strong></p>";
        String expected = "<p><strong>bold text</strong></p>";
        this.verify(expected, input);
    }

    @Test
    public void paragraphsSeparated() {
        String input = "<p>para 1</p><p>para 2</p>";
        String expected = "<p>para 1</p>\n\n<p>para 2</p>";
        this.verify(input, input);
        this.cleaner.setPrettyPrint(true);
        this.verify(expected, input);
    }

    @Test
    public void preformattedBlocks() {
        String[] tagsToTest;
        for (String tag : tagsToTest = new String[]{"pre", "script"}) {
            String input = "<" + tag + ">Line1\nLine2\nLine3</" + tag + ">";
            this.verify(input, input);
        }
    }

    @Test
    public void styleTagsAreStripped() {
        String input = "<style type='text/css'>body { color: magenta; }</style>";
        String expected = "";
        this.verify(expected, input);
    }

    @Test
    public void styleTagsNotStrippedFromBody() {
        String expected = "<style type=\"text/css\">body { color: magenta; }</style>";
        String input = "<html><body>" + expected + "</body><html>";
        this.verify(expected, input);
    }

    @Test
    public void styleTagBetweenParagraphs() {
        String input = "<html><body><p>One</p>\n <style>Two</style>\n <p>Three</p>\n</body></html>";
        String expected = "<p>One</p>\n <style>Two</style>\n <p>Three</p>";
        this.verify(expected, input);
    }

    @Test
    public void indent() {
        this.cleaner.setPrettyPrint(true);
        String input = "<ul><li>Item1</li><li>Item2</li></ul>";
        String expected = "<ul>\n  <li>Item1</li>\n  <li>Item2</li>\n</ul>";
        this.verify(expected, input);
    }

    @Test
    public void commentsPreserved() {
        String comment = "<!-- SITEBUILDER_MERGE_DYNAMIC_STATIC -->";
        String input = "<p>Inconsequential text</p>\n " + comment + " \n<p>More text.</p>";
        String output = this.cleaner.clean(input, new MutableContent(null, null));
        Assert.assertTrue((String)"comment preserved", (boolean)output.contains(comment));
    }

    @Test
    public void escapingInScriptTags() {
        String input = "<script type=\"text/javascript\"><!--// <![CDATA[\n var c = 3;\n // ]]> --></script>";
        this.verify(input, input);
    }

    @Test
    public void moreScriptTags() {
        String input = "<script>\n if (3 < 4) alert('the world is round'); \n</script>";
        this.verify(input, input);
    }

    @Test
    public void relativeLinks() {
        String input = "<p>A <a href=\"../page.htm\">relative link</a>.</p>";
        this.verify(input, input);
    }

    @Test
    public void useStupidTinyMceLinks() {
        String input = "<p><a href=\"http://server/page/page/../page.htm\" mce_href=\"../page.htm\">link</a></p>";
        String expected = "<p><a href=\"../page.htm\">link</a></p>";
        this.verify(expected, input);
    }

    @Test
    public void useStupidTinyMceImages() {
        String input = "<p><img src=\"http://server/page/page/../picture.jpg\" mce_src=\"../picture.jpg\" /></p>";
        String expected = "<p><img src=\"../picture.jpg\" border=\"0\" /></p>";
        this.verify(expected, input);
    }

    @Test
    public void loneLeftBracketsAreEscaped() {
        String input = "<p>CrabSet <- Crab.</p>";
        String expected = "<p>CrabSet &lt;- Crab.</p>";
        this.verify(expected, input);
        input = "<p>Crab <3 Crab.</p>";
        expected = "<p>Crab &lt;3 Crab.</p>";
        this.verify(expected, input);
    }

    @Test
    public void imagesGivenBorders() {
        String noBorder = "<p><img src=\"image.jpg\" /></p>";
        String addedZeroBorder = "<p><img src=\"image.jpg\" border=\"0\" /></p>";
        String existingBorder = "<p><img src=\"image.jpg\" border=\"1\" /></p>";
        this.verify(existingBorder, existingBorder);
        this.verify(addedZeroBorder, noBorder);
    }

    @Test
    public void preUnchanged() {
        String input = "<pre>Text <b>bold</b> <q>hellolevel!</q>  \n<tt>teletype</tt>. \n <code>&gt; prompt</code>\n</pre>";
        this.verify(input, input);
    }

    @Test
    public void preTagsAccumulatingNewlines() {
        String input = "<pre>ball ball ball<br />\nfooty footy footy<br />\nball ball ball<br />\nFOOTBALL\n</pre>";
        this.verify(input, input);
    }

    @Test
    public void mceKeepIsRemoved() {
        String input = "<p class=\"awesome\" mce_keep=\"true\">test</p>";
        String expected = "<p class=\"awesome\">test</p>";
        this.verify(expected, input);
    }

    @Test
    public void mceStyle() {
        String input = "<div mce_style=\"text-align: center\">Hello</div>";
        String expected = "<div style=\"text-align: center\">Hello</div>";
        this.verify(expected, input);
        input = "<div style=\"text-align: center\" mce_style=\"text-align: center\">Hello</div>";
        expected = "<div style=\"text-align: center\">Hello</div>";
        this.verify(expected, input);
    }

    @Test
    public void paragraphCenter() {
        String standard = "<p style=\"text-align: center;\">Centre me</p>";
        String ie = "<p style=\"TEXT-ALIGN: center\">Centre me</p>";
        this.verify(standard, standard);
        this.verify(ie, ie);
    }

    @Test
    public void mceStyleOnSpan() {
        String input = "<span style=\"color: magenta\">Hello</span>";
        String expected = "Hello";
        this.verify(expected, input);
        input = "<span mce_style=\"color: magenta\">Hello</span>";
        expected = "Hello";
        this.verify(expected, input);
        input = "<span style=\"color: magenta\" mce_style=\"color: magenta\">Hello</span>";
        expected = "Hello";
        this.verify(expected, input);
    }

    @Test
    public void mceStyleDoesntKillOthers() {
        String input = "<a href=\"#\" mce_style=\"text-align: center\" style=\"text-align: center;\">Hello</a>";
        String expected = "<a href=\"#\" style=\"text-align: center\">Hello</a>";
        this.verify(expected, input);
    }

    @Test
    public void linkStyleIsKept() {
        String input;
        String expected = input = "Ra <a href=\"#\" style=\"granos\">Hello</a> Bye";
        this.verify(expected, input);
    }

    @Test
    public void mceImg() {
        String input = "<img mce_src=\"kitten.jpg\" border=\"0\">";
        String expected = "<img src=\"kitten.jpg\" border=\"0\" />";
        this.verify(expected, input);
    }

    @Test
    public void mceArea() {
        String input = "<map><area title=\"Pasqual Paoli - Corsican patriot\" alt=\"Pasqual Paoli - Corsican patriot\" coords=\"203,107,220,139\" mce_coords=\"203,107,220,139\" shape=\"rect\" mce_shape=\"rect\" href=\"/wiki/Pasquale_Paoli\" /></map>";
        String expected = "<map>  <area title=\"Pasqual Paoli - Corsican patriot\" alt=\"Pasqual Paoli - Corsican patriot\" coords=\"203,107,220,139\" shape=\"rect\" href=\"/wiki/Pasquale_Paoli\" /></map>";
        this.verifyNoLineBreaks(expected, input);
    }

    @Test
    public void emptyAttributesRemoved() {
        String input = "<td scope=\"\" style=\"\" dir=\"\" id=\"\" rowspan=\"1\" align=\"\" lang=\"\" valign=\"\">Blah</td>";
        String expected = "<table>  <tbody>    <tr>      <td rowspan=\"1\">Blah</td>    </tr>  </tbody></table>";
        this.verifyNoLineBreaks(expected, input);
    }

    @Test
    public void allowEmptyAltAttribute() {
        String input = "<img src=\"image.jpg\" border=\"\" alt=\"\" />";
        String expected = "<img src=\"image.jpg\" alt=\"\" />";
        this.verify(expected, input);
    }

    @Test
    public void disallowRepeatedTags() {
        String input = "<strong><strong><strong>test</strong></strong></strong>";
        String expected = "<strong>test</strong>";
        this.verify(expected, input);
    }

    @Test
    public void disallowRepeatedTagsDifferentTags() {
        String input = "<strong><em><strong>test</strong></em></strong>";
        String expected = "<strong><em>test</em></strong>";
        this.verify(expected, input);
    }

    @Test
    public void noNestedFormsPlease() {
        String input = "<form action='jim' method='post'><input type='blah' value='boo' /><form action='jim' method='post'><input type='blah' value='boo' /></form></form>";
        String expected = "<form action=\"jim\" method=\"post\">  <input type=\"blah\" value=\"boo\" />  <input type=\"blah\" value=\"boo\" /></form>";
        this.verifyNoLineBreaks(expected, input);
    }

    @Test
    public void removeOnlyMceClass() {
        String input = "a <img src=\"x.jpg\" class=\"mceItem square-tag\"> b";
        String expected = "a <img src=\"x.jpg\" class=\" square-tag\" border=\"0\" /> b";
        this.verify(expected, input);
    }

    @Test
    public void noMceMarkup() {
        String input = "<h3 class=\"mceItemHidden\">A title</h3>";
        String expected = "<h3>A title</h3>";
        this.verify(expected, input);
        input = "<p>A <a mce_thref=\"#somewhere\">stupid link</a>. <img mce_tsrc='sheep.gif' border=3 /> sheep lol</p>";
        expected = "<p>A <a href=\"#somewhere\">stupid link</a>. <img src=\"sheep.gif\" border=\"3\" /> sheep lol</p>";
        this.verify(expected, input);
    }

    @Test
    public void noMceMarkupNewUnderscoredVersion() {
        String input = "<h3 class=\"_mceItemHidden\">A title</h3>";
        String expected = "<h3>A title</h3>";
        this.verify(expected, input);
        input = "<p>A <a _mce_href=\"#somewhere\">stupid link</a>. <img _mce_src='sheep.gif' border=3 /> sheep lol</p>";
        expected = "<p>A <a href=\"#somewhere\">stupid link</a>. <img src=\"sheep.gif\" border=\"3\" /> sheep lol</p>";
        this.verify(expected, input);
    }

    @Test
    public void pastedNewWindowLinksAreRemoved() {
        String string = "<p>Hello I've pasted this <a href=\"blah\" target=\"_blank\">Link";
        String string2 = "</a> in from another page</p>";
        String input = string + "<img class='targetBlank' alt='' title='Link opens in a new window' src='/static_war/images/shim.gif' />" + string2;
        String expected = string + string2;
        this.verify(expected, input);
    }

    @Test
    public void mceBogus() {
        String input = "<p>Some test, la la!<br _mce_bogus=\"1\" /></p>";
        String expected = "<p>Some test, la la!</p>";
        this.verify(expected, input);
        input = "<p>Some test, la la!<br mce_bogus=1></p>";
        expected = "<p>Some test, la la!</p>";
        this.verify(expected, input);
    }

    @Test
    public void mceBogus2() {
        String input = "<p>Some test, la la!<br data-mce-bogus=\"1\" /></p>";
        String expected = "<p>Some test, la la!</p>";
        this.verify(expected, input);
        input = "<p>Some test, la la!<br data-mce-bogus=1></p>";
        expected = "<p>Some test, la la!</p>";
        this.verify(expected, input);
    }

    @Test
    public void mceScript() {
        String input = "<p><mce:script type=\"text/javascript\"><!--\nalert('Im a script!');\n// --></mce:script></p>";
        String expected = "<script type=\"text/javascript\"><!--\nalert('Im a script!');\n// --></script>";
        this.verify(expected, input);
    }

    @Test
    public void alignMiddleOnTableCells() {
        String input = "<table>";
        input = input + "<tr><th>Header 1</th><th align=\"middle\">Header 2</th><th cellpadding=\"1\" align=middle>Header 3</th></tr>";
        input = input + "<tr><td>Content 1</td><td align=\"middle\">Content 2</td><td cellpadding=\"1\" align=middle>Header 3</td></tr>";
        input = input + "</table>";
        String output = this.cleaner.clean(input, new MutableContent(null, null)).trim();
        Assert.assertTrue((boolean)output.contains("<td align=\"center\">"));
        Assert.assertTrue((boolean)output.contains("<th align=\"center\">"));
        Assert.assertFalse((boolean)output.contains("<td align=\"middle\">"));
    }

    @Test
    public void nastyOOWriterPasteTinyMCE3() throws Exception {
        String input = this.readResourceToString("/htmlClean/input5.html");
        String expected = "<p class=\"western\">Some nasty ass shit</p>";
        this.verify(expected, input);
    }

    @Test
    public void dontTrimTinyMCE3Indents() throws Exception {
        String input;
        String expected = input = "<h2 style=\"padding-left: 270px; \">blah blah blah</h2>\n\n<p style=\"padding-left: 60px;\">blah blah blah</p>";
        this.verify(expected, input);
    }

    @Test
    public void dontTrimTinyMCE3Aligns() throws Exception {
        String input;
        String expected = input = "<h2 style=\"text-align: middle;\">blah blah blah</h2>\n\n<p style=\"text-align: right;\">blah blah blah</p>";
        this.verify(expected, input);
    }

    @Test
    public void cleanEmptyStyleAttributes() throws Exception {
        String input = "<p style=\"\">blah blah blah</p>";
        String expected = "<p>blah blah blah</p>";
        this.verify(expected, input);
    }

    @Test
    public void stripMceStyleWithPadding() throws Exception {
        String input = this.readResourceToString("/htmlClean/input7.html");
        String expected = this.readResourceToString("/htmlClean/output7.html");
        this.verify(expected, input);
    }

    @Test
    public void nastyBlocking() throws Exception {
        String input = this.readResourceToString("/htmlClean/sbtwo-3275.html");
        long start = System.currentTimeMillis();
        this.cleaner.clean(input, new MutableContent(null, null));
        long stop = System.currentTimeMillis();
        Assert.assertTrue((stop - start < 5000L ? 1 : 0) != 0);
    }

    @Test
    public void webkitFormattingSpans() throws Exception {
        String input = this.readResourceToString("/htmlClean/input9.html");
        String expected = this.readResourceToString("/htmlClean/output9.html");
        this.verifyIgnoringTrailingWhitespace(expected, input);
    }

    @Test
    public void ieIndenting() throws Exception {
        String input = this.readResourceToString("/htmlClean/input8.html");
        String expected = this.readResourceToString("/htmlClean/output8.html");
        this.verify(expected, input);
    }

    @Test
    public void sbtwo3564LotsOfSpans() throws Exception {
        String input = this.readResourceToString("/htmlClean/sbtwo-3564.html");
        String expected = this.readResourceToString("/htmlClean/sbtwo-3564-expected.html");
        this.verifyIgnoringTrailingWhitespace(expected, input);
    }

    @Test
    public void sbtwo3574ChromeBoldening() throws Exception {
        String input = "<p>Hello, <span mce_name=\"strong\" mce_style=\"font-weight: bold;\" class=\"Apple-style-span\" style=\"font-weight: bold; \">my<span class=\"Apple-style-span\" style=\"font-weight: normal;\" mce_style=\"font-weight: normal;\" mce_fixed=\"1\"> <em>name</em> is</span> Nick</span></p>";
        String expected = "<p>Hello, <strong>my</strong> <em>name</em> is<strong> Nick</strong></p>";
        this.verify(expected, input);
    }

    @Test
    public void utl72BackgroundEqBackground() throws Exception {
        String input = "Here is a <em background=\"background\" align=\"align\">Rubbish</em> How magic";
        String expected = "Here is a <em>Rubbish</em> How magic";
        this.verifyNoLineBreaks(expected, input);
    }

    @Test
    public void utl72InvalidStyle() throws Exception {
        String input = "Here is a <div style=\"background-image: url(background);\">Rubbish</div> How magic";
        String expected = "Here is a <div>Rubbish</div> How magic";
        this.verifyNoLineBreaks(expected, input);
    }

    @Test
    public void html5Video() throws Exception {
        String input = this.readResourceToString("/htmlClean/video-tag.html");
        String expected = this.readResourceToString("/htmlClean/video-tag.html");
        this.verifyNoLineBreaks(expected, input);
    }

    @Test
    public void removeInvisibleSandwiches() throws Exception {
        String range = "Something happens<span id='_mce_start' style='display:none;line-height:0'>&#65279;</span> and I get my invisible sandwiches<span id='_mce_end' style='display:none;line-height:0'>&#65279;</span> for breakfast.";
        String expected = "Something happens and I get my invisible sandwiches for breakfast.";
        this.verify(expected, range);
    }

    @Test
    public void sbtwo3782_orphanLightboxLink() throws Exception {
        String input = "<P>Hello I like <a href=\"http://www.google.com\">Google</a>. <STRONG><A title='koala.jpg' href=\"http://www2-test.warwick.ac.uk/services/its/intranet/projects/webdev/sandbox/nickhowes/koala.jpg\" rel=lightbox[all] _mce_href=\"koala.jpg\"></A><BR></STRONG></P>";
        String expected = "<p>Hello I like <a href=\"http://www.google.com\">Google</a>. <strong><br /></strong></p>";
        this.verify(expected, input);
    }

    @Test
    public void sbtwo3782_regularLightboxLink() throws Exception {
        String input = "<P>Hello I like <a href=\"http://www.google.com\">Google</a>. <STRONG><A title='koala.jpg' href=\"http://www2-test.warwick.ac.uk/services/its/intranet/projects/webdev/sandbox/nickhowes/koala.jpg\" rel=lightbox[all] _mce_href=\"koala.jpg\"><img src=\"koala.jpg\"></A><BR></STRONG> badgers</P>";
        String expected = "<p>Hello I like <a href=\"http://www.google.com\">Google</a>. <strong><a title=\"koala.jpg\" rel=\"lightbox[all]\" href=\"koala.jpg\"><img src=\"koala.jpg\" border=\"0\" /></a><br /></strong> badgers</p>";
        this.verify(expected, input);
    }

    @Test
    public void sbtwo3830() throws Exception {
        String input = "<p>Something <span class=\"Apple-style-span\" style=\"font-weight: normal;\" mce_style=\"font-weight: normal;\">wonderful</span> has happened.</p>";
        String expected = "<p>Something wonderful has happened.</p>";
        this.verify(expected, input);
    }

    @Test
    public void sbtwo3874_prettyPrint() {
        String input = "<th align='center'>       \n        \n\n\n      \n</TH>";
        String expectedPretty = "<table>\n  <tbody>\n    <tr>\n      <th align=\"center\">&nbsp;</th>\n    </tr>\n  </tbody>\n</table>";
        String expectedPlain = "<table><tbody><tr><th align=\"center\">&nbsp;</th></tr></tbody></table>";
        this.verify(expectedPlain, input);
        this.cleaner.setPrettyPrint(true);
        this.verify(expectedPretty, input);
    }

    @Test
    public void sbtwo4051() {
        String input = "<img src=\"http://java-monkey.warwick.ac.uk/services/its/elab/about/people/nickhowes/pagetypes/news/809-3.jpg\" _mce_src=\"809-3.jpg\" mce_src=\"809-3.jpg\" alt=\"Moomins\">";
        String expected = "<img src=\"809-3.jpg\" alt=\"Moomins\" border=\"0\" />";
        this.verify(expected, input);
    }

    @Test
    public void sbtwo4230() {
        String input = "<table><tr><td>&nbsp;</td><td>  &nbsp; </td></tr></table>\n<p>Hey how's&nbsp;it going. &nbsp;I&nbsp;like    your    socks.&nbsp; Yeah, nice socks.</p>\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mysterious indenting!</p>\n";
        String expected = "<table><tr><td>&nbsp;</td><td>&nbsp;</td></tr></table>\n<p>Hey how's it going.  I like    your    socks.  Yeah, nice socks.</p>\n<p> Mysterious indenting!</p>";
        this.verify(expected, input);
        this.verify("<p>Toast.  Toast.  Toast.</p>", "<p>Toast.&nbsp; Toast. &nbsp;Toast.</p>");
    }

    @Test
    public void kbd() throws Exception {
        String input = "<p>Here is a <kbd>Command</kbd>s keyboard command</p>";
        this.verify(input, input);
    }

    @Test
    public void html5() throws Exception {
        String input = this.readResourceToString("/htmlClean/input10.html");
        this.verifyNoLineBreaks(input);
    }

    @Test
    public void sbtwo7119() throws Exception {
        String input = "<a href=\"jim\">\n  <h2>Jim</h2>\n  <p>Sings</p>\n</a>";
        this.verifyNoLineBreaks(input, input);
    }

    @Test
    public void sbtwo7120() throws Exception {
        String input = "<i class=\"fa fa-user\"></i>";
        this.verify(input, input);
    }

    @Test
    public void unicodeCharactersRemain() {
        String input = "<p>\uc9c0\uad6c\uc0c1\uc758\uc9c0\uad6c\uc0c1\uc758\uc9c0\uad6c\uc0c1\uc758\uc9c0\uad6c\uc0c1\uc758\uc9c0\uad6c\uc0c1\uc758\u00a3</p>";
        this.verify(input, input);
    }

    @Test
    public void leaveSVGalone() {
        String input = "<svg version=\"1.2\" viewbox=\"0 0 1500 1500\"> \n  <g id=\"myTestLayer\"> \n    <path id=\"myTestPath\" class=\"st0\" d=\"M710.5,264.6l132-3.9l4.3,284.6z\"></path>\n  </g>\n</svg>";
        this.verify(input, input);
    }

    @Test
    public void sbtwo9435_cleanEmptyParasAndHeadings() throws IOException {
        String input = this.readResourceToString("/htmlClean/sbtwo-9435.html");
        String expected = this.readResourceToString("/htmlClean/sbtwo-9435-expected.html");
        this.verify(expected, input);
    }

    @Test
    public void customElements() {
        String input = "<p>Message me at <email-link data-address=\"example@warwick.ac.uk\"></email-link>.</p>";
        String expected = "<p>Message me at <email-link data-address=\"example@warwick.ac.uk\"></email-link>.</p>";
        this.verify(expected, input);
    }

    private void verifyNoLineBreaks(String input) {
        this.verifyNoLineBreaks(input, input);
    }

    private void verify(@NotNull String expected, @NotNull String input) {
        this.verify(expected, input, Function.identity());
    }

    private void verify(@NotNull String expected, @NotNull String input, @NotNull Function<String, String> cleanup) {
        String output = this.cleaner.clean(input, new MutableContent(null, null)).trim();
        Assert.assertEquals((Object)cleanup.apply(expected).replace("\r", ""), (Object)cleanup.apply(output).replace("\r", ""));
        this.verifyIdempotence(expected, false);
    }

    private void verifyIgnoringTrailingWhitespace(String expected, String input) {
        this.verify(expected, input, s -> TRAILING_WHITESPACE.matcher((CharSequence)s).replaceAll(""));
    }

    private void verifyIdempotence(String html, boolean trimLineBreaks) {
    }

    private void actuallyVerifyIdempotence(String html, boolean trimLineBreaks) {
        String currentContent = html;
        for (int i = 0; i < 5; ++i) {
            String cleaned = this.cleaner.clean(currentContent, new MutableContent(null, null)).trim();
            if (trimLineBreaks) {
                cleaned = this.trimLineBreaks(cleaned);
            }
            Assert.assertEquals((String)("Re-cleanup number " + (i + 1) + " changed"), (Object)html, (Object)cleaned);
            currentContent = cleaned;
        }
    }

    private void verifyNoLineBreaks(String expected, String input) {
        String output = this.trimLineBreaks(this.cleaner.clean(input, new MutableContent(null, null)));
        expected = this.trimLineBreaks(expected);
        Assert.assertEquals((Object)expected, (Object)output);
        this.verifyIdempotence(expected, true);
    }

    private String trimLineBreaks(String clean) {
        return clean.trim().replace("\n", "").replace("\t", "").replace("\r", "").replaceAll(">\\s+<", "><");
    }

    private String readResourceToString(String filename) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(filename);
        if (is == null) {
            throw new FileNotFoundException(filename);
        }
        String input = FileCopyUtils.copyToString((Reader)new InputStreamReader(is));
        return input;
    }
}

