/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.concurrency;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.concurrency.ImmediateCallable;
import uk.ac.warwick.util.concurrency.TaskExecutionService;

public final class ImmediateCallableTest {
    @Test
    public void newInstance() throws Exception {
        TaskExecutionService service = new TaskExecutionService(1);
        Future future = service.submit(ImmediateCallable.newInstance((Object)7));
        Assert.assertNotNull((Object)future);
        Assert.assertEquals((long)7L, (long)((Integer)future.get()).intValue());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void errorInstance() throws Exception {
        IllegalStateException ex = new IllegalStateException("Invalid");
        TaskExecutionService service = new TaskExecutionService(1);
        Future future = service.submit(ImmediateCallable.errorInstance((Exception)ex));
        Assert.assertNotNull((Object)future);
        try {
            future.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }
}

