/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections.google;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.TestCase;
import uk.ac.warwick.util.collections.google.InternalIterable;

public class InternalIterableTest
extends TestCase {
    private InternalIterable<String> words = InternalIterable.of((Iterable)Lists.newArrayList((Object[])new String[]{"ham", "home", "from", "fish", "have", "ham"}));
    private static Ordering<String> alpha = Ordering.natural();

    public static void main(String[] args) {
        InternalIterable namesAndNulls = InternalIterable.of((Iterable)Lists.newArrayList((Object[])new String[]{"chris", "nick", null, "kieran", null, null, "hongfeng", "mat", "sarah"}));
        for (Object name : namesAndNulls.filter(Predicates.not((Predicate)Predicates.isNull()))) {
            System.out.println((String)name + " has " + ((String)name).length() + " letters");
        }
        Function<String, String> reverser = new Function<String, String>(){

            public String apply(String arg0) {
                return new StringBuffer(arg0).reverse().toString();
            }
        };
        for (String name : namesAndNulls.filter(Predicates.not((Predicate)Predicates.isNull())).transform((Function)reverser)) {
            System.out.println(name);
        }
        String nonNull = (String)InternalIterable.of((Iterable)Lists.newArrayList((Object[])new String[]{null, null, "I'm not null!", "nor me"})).find(Predicates.not((Predicate)Predicates.isNull()));
        System.out.println("First non-null element is " + nonNull);
        InternalIterable.Injector<Map<String, String>, String> mapper = new InternalIterable.Injector<Map<String, String>, String>((Function)reverser){
            final /* synthetic */ Function val$reverser;
            {
                this.val$reverser = function;
            }

            public Map<String, String> apply(Map<String, String> memo, String element) {
                memo.put(element, (String)this.val$reverser.apply((Object)element));
                return memo;
            }
        };
        Set entries = ((Map)namesAndNulls.filter(Predicates.not((Predicate)Predicates.isNull())).sort(alpha).inject(new LinkedHashMap(), (InternalIterable.Injector)mapper)).entrySet();
        for (Map.Entry entry : entries) {
            System.out.println((String)entry.getKey() + " backwards is " + (String)entry.getValue());
        }
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : namesAndNulls) {
            if (string == null) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList, alpha);
        for (String string : arrayList) {
            results.put(string, reverser.apply((Object)string));
        }
        for (Map.Entry entry : entries) {
            System.out.println((String)entry.getKey() + " backwards is " + (String)entry.getValue());
        }
    }

    public void testFilter() {
        Predicate<String> startsWithH = new Predicate<String>(){

            public boolean apply(String s) {
                return s.startsWith("h");
            }
        };
        InternalIterable hWords = this.words.filter((Predicate)startsWithH);
        InternalIterableTest.assertEquals((String)"fish", (String)((String)Iterables.find(this.words, (Predicate)Predicates.equalTo((Object)"fish"))));
        try {
            Iterables.find((Iterable)hWords, (Predicate)Predicates.equalTo((Object)"fish"));
            InternalIterableTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testTransform() {
        Function<String, Boolean> startsWithH = new Function<String, Boolean>(){

            public Boolean apply(String s) {
                return s.startsWith("h");
            }
        };
        InternalIterable results = this.words.transform((Function)startsWithH);
        Iterator expectedResults = Lists.newArrayList((Object[])new Boolean[]{true, true, false, false, true, true}).iterator();
        for (Boolean result : results) {
            Boolean e = (Boolean)expectedResults.next();
            InternalIterableTest.assertEquals((Object)e, (Object)result);
        }
    }

    public void testAnyAndAll() {
        CallCountingPredicate nonZeroLength = new CallCountingPredicate(){

            public boolean apply(String arg0) {
                this.incCount();
                return arg0.length() > 0;
            }
        };
        CallCountingPredicate beginsWithH = new CallCountingPredicate(){

            public boolean apply(String arg0) {
                this.incCount();
                return arg0.startsWith("h");
            }
        };
        InternalIterableTest.assertTrue((boolean)this.words.all((Predicate)nonZeroLength));
        InternalIterableTest.assertEquals((int)6, (int)nonZeroLength.getCount());
        InternalIterableTest.assertFalse((boolean)this.words.all((Predicate)beginsWithH));
        InternalIterableTest.assertEquals((int)3, (int)beginsWithH.getCount());
        InternalIterableTest.assertTrue((boolean)this.words.any((Predicate)beginsWithH));
        InternalIterableTest.assertEquals((int)4, (int)beginsWithH.getCount());
    }

    public void testSort() {
        InternalIterable sorted = this.words.sort(alpha);
        InternalIterableTest.assertEquals((String)"fish", (String)((String)sorted.iterator().next()));
        Ordering<String> reverse = new Ordering<String>(){

            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        };
        sorted = this.words.sort((Ordering)reverse);
        InternalIterableTest.assertEquals((String)"home", (String)((String)sorted.iterator().next()));
        InternalIterableTest.assertEquals((String)"ham", (String)((String)this.words.iterator().next()));
    }

    public void testFind() {
        Predicate<String> startsWithH = new Predicate<String>(){

            public boolean apply(String s) {
                return s.startsWith("h");
            }
        };
        InternalIterableTest.assertEquals((String)"ham", (String)((String)this.words.find((Predicate)startsWithH)));
        try {
            this.words.find(Predicates.alwaysFalse());
            InternalIterableTest.fail();
        }
        catch (NoSuchElementException e) {
            InternalIterableTest.assertTrue((String)"expected", (boolean)true);
        }
    }

    public void testInject() {
        InternalIterable.Injector<Map<String, Integer>, String> wordCounter = new InternalIterable.Injector<Map<String, Integer>, String>(){

            public Map<String, Integer> apply(Map<String, Integer> memo, String element) {
                if (memo.containsKey(element)) {
                    memo.put(element, memo.get(element) + 1);
                } else {
                    memo.put(element, 1);
                }
                return memo;
            }
        };
        Map result = (Map)this.words.inject(new HashMap(), (InternalIterable.Injector)wordCounter);
        InternalIterableTest.assertEquals((int)5, (int)result.size());
        InternalIterableTest.assertEquals((Object)2, result.get("ham"));
        InternalIterableTest.assertEquals((Object)1, result.get("home"));
    }

    abstract class CallCountingPredicate
    implements Predicate<String> {
        private int count = 0;

        CallCountingPredicate() {
        }

        protected void incCount() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }
    }
}

