/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.collections.PairIterator;

public class PairIteratorTests
extends TestCase {
    final List<String> shorter = Arrays.asList("foo", "bar", "buz");
    final List<String> longer = Arrays.asList("bish", "bosh", "bash", "bang");

    public void testConstructors() {
        new PairIterator(this.shorter, this.longer);
        new PairIterator(this.longer.iterator(), this.shorter.iterator());
        PairIterator.of(this.shorter, this.longer).iterator();
    }

    public void testIterate() {
        Iterable pi = PairIterator.of(this.shorter, this.longer);
        int itemsReturned = 0;
        for (Pair pair : pi) {
            PairIteratorTests.assertNotNull((Object)pair);
            ++itemsReturned;
        }
        PairIteratorTests.assertEquals((int)this.longer.size(), (int)itemsReturned);
    }

    public void testCantRemove() {
        Iterable pi = PairIterator.of(this.shorter, this.longer);
        try {
            pi.iterator().remove();
            PairIteratorTests.fail((String)"No exception thrown on remove!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testIteratePastEndOfOneCollection() {
        Iterable pi = PairIterator.of(this.shorter, this.longer);
        Pair pair = (Pair)PairIteratorTests.skip(pi, 3).iterator().next();
        PairIteratorTests.assertEquals((String)"bang", (String)((String)pair.getRight()));
        PairIteratorTests.assertNull((Object)pair.getLeft());
    }

    private static <T> Iterable<T> skip(final Iterable<T> iterable, final int skip) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator iterator = iterable.iterator();
                for (int i = 0; i < skip; ++i) {
                    iterator.next();
                }
                return iterator;
            }
        };
    }
}

