/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import junit.framework.TestCase;
import uk.ac.warwick.util.collections.CollectionUtils;

public final class CollectionUtilsTest
extends TestCase {
    public void testGroupByProperty() {
        int i;
        String valueA = "valueA";
        String valueB = "valueB";
        int numberOfValueAs = 3;
        int numberOfValueBs = 4;
        CollectionUtilsTest.assertFalse((boolean)false);
        ArrayList<NestedObject> allAs = new ArrayList<NestedObject>(3);
        ArrayList<NestedObject> allBs = new ArrayList<NestedObject>(4);
        for (i = 0; i < 3; ++i) {
            allAs.add(new NestedObject(new String("valueA")));
        }
        for (i = 0; i < 4; ++i) {
            allBs.add(new NestedObject(new String("valueB")));
        }
        ArrayList<NestedObject> all = new ArrayList<NestedObject>(7);
        all.addAll(allAs);
        all.addAll(allBs);
        String propertyName = "property";
        SortedMap map = CollectionUtils.groupByProperty(all, (String)"property");
        CollectionUtilsTest.assertEquals((String)"number of groups", (int)2, (int)map.size());
        CollectionUtilsTest.assertEquals((String)"valueAs", allAs, map.get("valueA"));
        CollectionUtilsTest.assertEquals((String)"valueBs", allBs, map.get("valueB"));
    }

    public void testToSetWithSet() {
        HashSet<String> mySet = new HashSet<String>();
        mySet.add("word");
        CollectionUtilsTest.assertEquals(mySet, (Object)CollectionUtils.toSet(mySet));
    }

    public void testToSetWithList() {
        LinkedList<String> myList = new LinkedList<String>();
        myList.add("one");
        myList.add("two");
        myList.add("three");
        myList.add("two");
        Set theSet = CollectionUtils.toSet(myList);
        CollectionUtilsTest.assertEquals((int)3, (int)theSet.size());
        CollectionUtilsTest.assertTrue((boolean)theSet.containsAll(myList));
    }

    public void testCountOccurrences() {
        List<String> myList = Arrays.asList("twice", "thrice", "twice", "4", "thrice", "thrice", "once", "4", "4", "4");
        Map results = CollectionUtils.countOccurrences(myList);
        CollectionUtilsTest.assertEquals((Object)1, results.get("once"));
        CollectionUtilsTest.assertEquals((Object)2, results.get("twice"));
        CollectionUtilsTest.assertEquals((Object)3, results.get("thrice"));
        CollectionUtilsTest.assertEquals((Object)4, results.get("4"));
    }

    public void testFilterByClass() {
        ArrayList<A> list = new ArrayList<A>();
        list.add(new C());
        list.add(new C());
        list.add(new C());
        list.add(new C());
        list.add(new D());
        list.add(new D());
        list.add(new D());
        list.add(new D());
        Collection cList = CollectionUtils.filterByClass(list, C.class);
        CollectionUtilsTest.assertNotNull((Object)cList);
        CollectionUtilsTest.assertEquals((int)cList.size(), (int)4);
    }

    public void testIterableEnumerable() {
        Vector<String> vector = new Vector<String>();
        vector.add("Hello");
        vector.add(", ");
        vector.add("World");
        StringBuilder sb = new StringBuilder();
        for (String s : CollectionUtils.iterable(vector.elements())) {
            sb.append(s);
        }
        CollectionUtilsTest.assertEquals((String)"Hello, World", (String)sb.toString());
    }

    class NestedObject {
        public static final String PROPERTY_NAME = "property";
        public final Object object;

        public NestedObject() {
            this.object = null;
        }

        public NestedObject(Object theObject) {
            this.object = theObject;
        }

        public Object getProperty() {
            return this.object;
        }
    }

    class D
    implements A {
        D() {
        }
    }

    class C
    extends B
    implements A {
        C() {
        }
    }

    abstract class B
    implements A {
        B() {
        }
    }

    static interface A {
    }
}

