/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import java.io.Serializable;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.cache.BasicCache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CacheStore;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.SingularCacheEntryFactory;
import uk.ac.warwick.util.cache.TTLCacheExpiryStrategy;
import uk.ac.warwick.util.cache.memcached.AbstractMemcachedCacheStoreTest;

public class MemcachedCacheStoreServerProblemsTest
extends AbstractMemcachedCacheStoreTest<String, String> {
    private int cacheCallCount = 0;
    private BasicCache<String, String, Object> cache;

    @Before
    public void setUpCache() {
        this.cache = new BasicCache((CacheStore)this.cacheStore, Caches.wrapFactoryWithoutDataInitialisation((CacheEntryFactory)new SingularCacheEntryFactory<String, String>(){

            public String create(String key) {
                MemcachedCacheStoreServerProblemsTest.this.cacheCallCount++;
                return key.substring(6);
            }

            public boolean shouldBeCached(String val) {
                return true;
            }
        }), (CacheExpiryStrategy)TTLCacheExpiryStrategy.forTTL((Duration)Duration.ofSeconds(10L)), false, false);
    }

    @Test
    public void handlesUnavailableServerGracefully() throws Exception {
        Assert.assertEquals((Object)"12345", (Object)this.cache.get((Serializable)((Object)"token:12345")));
        this.assertSize(1);
        Assert.assertEquals((long)1L, (long)this.cacheCallCount);
        daemon.stop();
        Assert.assertEquals((Object)"12345", (Object)this.cache.get((Serializable)((Object)"token:12345")));
        Assert.assertEquals((long)2L, (long)this.cacheCallCount);
    }
}

