/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.warwick.util.cache.BasicCache;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.SingularCacheEntryFactory;
import uk.ac.warwick.util.cache.TTLCacheExpiryStrategy;
import uk.ac.warwick.util.cache.memcached.MemcachedCacheStore;
import uk.ac.warwick.util.core.DateTimeUtils;

@Ignore(value="Doesn't work on Bamboo")
public class MemcachedCacheStoreServerDownTest {
    private static MemcachedCacheStore<String, String> cacheStore;
    private int cacheCallCount = 0;
    private Cache<String, String> cache;

    @BeforeClass
    public static void setup() throws Exception {
        MemcachedClient client = new MemcachedClient(new ConnectionFactoryBuilder().setOpTimeout(100L).build(), AddrUtil.getAddresses((String)"localhost:12345"));
        cacheStore = new MemcachedCacheStore("cacheName", Duration.ofSeconds(Integer.MAX_VALUE), client);
    }

    @Before
    public void setUpCache() {
        this.cache = new BasicCache(cacheStore, Caches.wrapFactoryWithoutDataInitialisation((CacheEntryFactory)new SingularCacheEntryFactory<String, String>(){

            public String create(String key) {
                MemcachedCacheStoreServerDownTest.this.cacheCallCount++;
                return key.substring(6);
            }

            public boolean shouldBeCached(String val) {
                return true;
            }
        }), (CacheExpiryStrategy)TTLCacheExpiryStrategy.forTTL((Duration)Duration.ofSeconds(10L)), false, false);
    }

    @Test
    public void get() throws Exception {
        Assert.assertEquals((Object)"12345", (Object)this.cache.get((Serializable)((Object)"token:12345")));
        Assert.assertEquals((long)1L, (long)this.cacheCallCount);
        Assert.assertEquals((Object)"12345", (Object)this.cache.get((Serializable)((Object)"token:12345")));
        Assert.assertEquals((long)2L, (long)this.cacheCallCount);
    }

    @Test
    public void getResult() {
        DateTimeUtils.useMockDateTime((TemporalAccessor)Instant.now(), () -> {
            try {
                Cache.Result result = this.cache.getResult((Serializable)((Object)"token:12345"));
                Assert.assertEquals((long)Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).toEpochMilli(), (long)result.getLastUpdated());
                Assert.assertEquals((Object)"12345", (Object)result.getValue());
                Assert.assertFalse((boolean)result.isUpdating());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    @Test
    public void put() {
        this.cache.put(new CacheEntry((Serializable)((Object)"token:12345"), (Serializable)((Object)"12345")));
    }

    @Test
    public void remove() {
        this.cache.remove((Serializable)((Object)"token:12345"));
    }

    @Test
    public void clear() {
        this.cache.clear();
    }

    @Test
    public void contains() {
        Assert.assertFalse((boolean)this.cache.contains((Serializable)((Object)"token:12345")));
        this.cache.put(new CacheEntry((Serializable)((Object)"token:12345"), (Serializable)((Object)"12345")));
        Assert.assertFalse((boolean)this.cache.contains((Serializable)((Object)"token:12345")));
    }
}

