/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.memcached.AbstractMemcachedCacheStoreTest;

public class MemcachedCacheStoreComplexKeyTest
extends AbstractMemcachedCacheStoreTest<ComplexKey, ComplexValue> {
    @Test
    public void complexKey() throws Exception {
        CacheEntry string = this.cacheStore.get((Serializable)new ComplexKey("token:abcdefghij"));
        Assert.assertNull((Object)string);
        CacheEntry entry = new CacheEntry((Serializable)new ComplexKey("token:12345"), (Serializable)new ComplexValue("Johnny"));
        this.cacheStore.put(entry, Duration.ofSeconds(10L));
        Assert.assertEquals((Object)entry.getValue(), (Object)this.cacheStore.get((Serializable)new ComplexKey("token:12345")).getValue());
        Assert.assertEquals((Object)entry.getValue(), (Object)this.cacheStore.get((Serializable)new ComplexKey("token:12345")).getValue());
        this.assertSize(1);
        Map stats = (Map)this.client.getStats().values().iterator().next();
        Assert.assertEquals((Object)"2", stats.get("get_hits"));
        Assert.assertEquals((Object)Integer.toString(2), stats.get("get_misses"));
        this.cacheStore.clear();
        Assert.assertNull((Object)this.cacheStore.get((Serializable)new ComplexKey("token:12345")));
    }

    static final class ComplexValue
    implements Serializable {
        private final String baseValue;

        ComplexValue(String baseValue) {
            this.baseValue = baseValue;
        }

        public String getBaseValue() {
            return this.baseValue;
        }

        public boolean equals(Object obj) {
            return obj instanceof ComplexValue && ((ComplexValue)obj).getBaseValue().equals(this.getBaseValue());
        }

        public int hashCode() {
            return this.getBaseValue().hashCode();
        }
    }

    static final class ComplexKey
    implements Serializable {
        private final String baseKey;

        ComplexKey(String baseKey) {
            this.baseKey = baseKey;
        }

        public String getBaseKey() {
            return this.baseKey;
        }

        public boolean equals(Object obj) {
            return obj instanceof ComplexKey && ((ComplexKey)obj).getBaseKey().equals(this.getBaseKey());
        }

        public int hashCode() {
            return this.getBaseKey().hashCode();
        }
    }
}

