/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.memcached;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheImpl;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Random;
import net.spy.memcached.MemcachedClient;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import uk.ac.warwick.util.cache.MemcachedUtils;
import uk.ac.warwick.util.cache.memcached.MemcachedCacheStore;

public class AbstractMemcachedCacheStoreTest<K extends Serializable, V extends Serializable> {
    private static final String CACHE_NAME = "customCache";
    protected static final MemCacheDaemon<LocalCacheElement> daemon = new MemCacheDaemon();
    private static InetSocketAddress memcachedAddress;
    protected MemcachedCacheStore<K, V> cacheStore;
    protected MemcachedClient client;

    @BeforeClass
    public static void setupMemcachedServerAndClient() {
        ConcurrentLinkedHashMap storage = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.FIFO, (int)1000, (long)16384L);
        daemon.setCache((Cache)new CacheImpl((CacheStorage)storage));
        daemon.setBinary(false);
        Random r = new Random();
        int low = 20000;
        int high = 30000;
        int port = r.nextInt(high - low) + low;
        memcachedAddress = new InetSocketAddress("localhost", port);
        daemon.setAddr(memcachedAddress);
        daemon.setIdleTime(30000);
        daemon.setVerbose(true);
        daemon.start();
    }

    @AfterClass
    public static void shutdownMemcachedServerAndClient() {
        daemon.stop();
    }

    @Before
    public void setUp() throws Exception {
        MemcachedUtils.setUp();
        this.client = new MemcachedClient(new InetSocketAddress[]{memcachedAddress});
        this.cacheStore = new MemcachedCacheStore(CACHE_NAME, Duration.ofSeconds(10L), this.client);
    }

    @After
    public void tearDown() {
        if (!this.client.getAvailableServers().isEmpty()) {
            this.cacheStore.clear();
            this.cacheStore.shutdown();
        }
        MemcachedUtils.tearDown();
        daemon.stop();
        daemon.start();
    }

    protected void assertSize(int size) throws Exception {
        Assert.assertEquals((long)size, (long)this.cacheStore.getStatistics().getCacheSize());
    }
}

