/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.caffeine.CaffeineCacheStore;

public class CaffeineCacheStoreTest {
    private static final String CACHE_NAME = "customCache";

    @Test
    public void creation() {
        Cache caffeineCache = Caffeine.newBuilder().build();
        CaffeineCacheStore store = new CaffeineCacheStore(CACHE_NAME, caffeineCache);
        CacheEntry string = store.get((Serializable)((Object)"token:abcdefghij"));
        Assert.assertNull((Object)string);
        CacheEntry entry = new CacheEntry((Serializable)((Object)"token:12345"), (Serializable)((Object)"Johnny"));
        store.put(entry, Duration.ofSeconds(10L));
        Assert.assertSame((Object)entry, (Object)store.get((Serializable)((Object)"token:12345")));
        Assert.assertSame((Object)entry, (Object)store.get((Serializable)((Object)"token:12345")));
        Assert.assertEquals((long)1L, (long)store.getStatistics().getCacheSize());
        Map bulk = store.getAll(Arrays.asList("token:12345", "token:67890"));
        Assert.assertEquals((long)2L, (long)bulk.size());
        Assert.assertSame((Object)entry, bulk.get("token:12345"));
        Assert.assertNull(bulk.get("token:67890"));
        Assert.assertEquals((long)1L, (long)store.getStatistics().getCacheSize());
        store.clear();
        Assert.assertEquals((long)0L, (long)store.getStatistics().getCacheSize());
    }

    @Test
    public void maxSize() {
        Cache caffeineCache = Caffeine.newBuilder().maximumSize(4L).build();
        CaffeineCacheStore store = new CaffeineCacheStore(CACHE_NAME, caffeineCache);
        Assert.assertEquals((long)0L, (long)store.getStatistics().getCacheSize());
        store.put(new CacheEntry((Serializable)((Object)"token:1"), (Serializable)((Object)"one")), Duration.ofSeconds(10L));
        Assert.assertEquals((long)1L, (long)store.getStatistics().getCacheSize());
        store.put(new CacheEntry((Serializable)((Object)"token:2"), (Serializable)((Object)"two")), Duration.ofSeconds(10L));
        Assert.assertEquals((long)2L, (long)store.getStatistics().getCacheSize());
        store.put(new CacheEntry((Serializable)((Object)"token:3"), (Serializable)((Object)"three")), Duration.ofSeconds(10L));
        store.put(new CacheEntry((Serializable)((Object)"token:4"), (Serializable)((Object)"three")), Duration.ofSeconds(10L));
        store.put(new CacheEntry((Serializable)((Object)"token:5"), (Serializable)((Object)"three")), Duration.ofSeconds(10L));
        store.put(new CacheEntry((Serializable)((Object)"token:6"), (Serializable)((Object)"three")), Duration.ofSeconds(10L));
        caffeineCache.cleanUp();
        Assert.assertEquals((long)4L, (long)store.getStatistics().getCacheSize());
    }
}

