/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.cache.CacheStore;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.HashMapCacheStore;
import uk.ac.warwick.util.cache.caffeine.CaffeineCacheStore;
import uk.ac.warwick.util.cache.memcached.MemcachedCacheStore;

public class CachesTest {
    private static final String CACHE_NAME = "customCache";

    @Test
    public void getCaffeine() {
        CacheStore store = Caches.builder((String)CACHE_NAME, (Caches.CacheStrategy)Caches.CacheStrategy.CaffeineIfAvailable).maximumSize(100L).buildStore();
        Assert.assertTrue((boolean)(store instanceof CaffeineCacheStore));
    }

    @Test
    public void getMemcache() {
        CacheStore store = Caches.builder((String)CACHE_NAME, (Caches.CacheStrategy)Caches.CacheStrategy.MemcachedIfAvailable).buildStore();
        Assert.assertTrue((boolean)(store instanceof MemcachedCacheStore));
    }

    @Test
    public void getInMemoryCache() {
        CacheStore store = Caches.builder((String)CACHE_NAME, (Caches.CacheStrategy)Caches.CacheStrategy.InMemoryOnly).buildStore();
        Assert.assertTrue((boolean)(store instanceof HashMapCacheStore));
    }
}

