/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.atom;

import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.WireFeedInput;
import com.rometools.rome.io.WireFeedOutput;
import java.io.Reader;
import java.io.StringReader;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.atom.spring.SitebuilderModuleGenerator;
import uk.ac.warwick.util.atom.spring.SitebuilderModuleImpl;

public final class SitebuilderModuleGeneratorTest {
    private final SitebuilderModuleGenerator generator = new SitebuilderModuleGenerator();

    @Test
    public void itWorks() throws Exception {
        Document document = new SAXBuilder().build((Reader)new StringReader("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:sitebuilder=\"http://go.warwick.ac.uk/elab-schemas/atom\"></entry>"));
        SitebuilderModuleImpl module = new SitebuilderModuleImpl();
        module.setPageOrder(Integer.valueOf(100));
        module.setAllowSearchEngines(Boolean.valueOf(true));
        module.setDescription("my description");
        module.setLastUpdateComment("an edit comment, shouldn't be in the output");
        this.generator.generate((Module)module, document.getRootElement());
        Feed feed = (Feed)new WireFeedInput().build(document);
        String outputAsString = new WireFeedOutput().outputString((WireFeed)feed, true);
        Assert.assertTrue((boolean)outputAsString.contains("<sitebuilder:searchable>true</sitebuilder:searchable>"));
        Assert.assertTrue((boolean)outputAsString.contains("<sitebuilder:description>my description</sitebuilder:description>"));
        Assert.assertTrue((boolean)outputAsString.contains("<sitebuilder:page-order>100</sitebuilder:page-order>"));
        Assert.assertFalse((boolean)outputAsString.contains("<sitebuilder:edit-comment>"));
    }
}

