/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ant;

import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.ant.YUICompressorFilter;

public class YUICompressorFilterTest
extends TestCase {
    private YUICompressorFilter filter;

    public void setUp() {
        this.filter = new YUICompressorFilter();
    }

    public void testFilter() {
        String input = "/* my library */\nvar albatross = 'my albatross';function z(ab,cd,efghi) {\n  return ab + cd + efghi;\n}\nfunction zz($super, x) {\n  x.call($super,arguments);\n}\n";
        String expected = "var albatross=\"my albatross\";\nfunction z(b,c,a){return b+c+a\n}function zz($super,a){a.call($super,arguments)\n};";
        String output = this.filter.filter(input);
        YUICompressorFilterTest.assertEquals((String)expected, (String)output);
    }

    public void testPrototype() throws Exception {
        String prototypeFile = "prototype-1.6.0.3.js";
        String prototype = FileCopyUtils.copyToString((Reader)new InputStreamReader(new ClassPathResource(prototypeFile).getInputStream()));
        int originalLength = prototype.length();
        String compressed = this.filter.filter(prototype);
        int newLength = compressed.length();
        int percent = newLength * 100 / originalLength;
        YUICompressorFilterTest.assertTrue((String)"Compression is not very good!", (percent < 70 ? 1 : 0) != 0);
        System.out.println(prototypeFile + " compressed to " + percent + "%");
    }
}

