/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.junit.Assert;
import uk.ac.warwick.userlookup.User;

public final class MockUtils {
    private MockUtils() {
    }

    public static Action continueFilterChain() {
        return new Action(){

            public Object invoke(Invocation invocation) throws Throwable {
                Object[] p = invocation.getParametersAsArray();
                try {
                    ServletRequest req = (ServletRequest)p[0];
                    ServletResponse res = (ServletResponse)p[1];
                    FilterChain chain = (FilterChain)p[2];
                    chain.doFilter(req, res);
                }
                catch (ClassCastException e) {
                    Assert.fail((String)"Unexpected class cast exception - is this action applied to doFilter()?");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Assert.fail((String)"Not enough method arguments - is this action applied to doFilter()?");
                }
                return null;
            }

            public void describeTo(Description d) {
                d.appendText("continue filter chain on doFilter");
            }
        };
    }

    public static Action setAttribute(final String name, final String value) {
        return new Action(){

            public Object invoke(Invocation invocation) throws Throwable {
                ServletRequest req = (ServletRequest)invocation.getParameter(0);
                req.setAttribute(name, (Object)value);
                return null;
            }

            public void describeTo(Description d) {
                d.appendText("Set request attribute ");
                d.appendValue((Object)name);
                d.appendText(" to ");
                d.appendValue((Object)value);
            }
        };
    }

    public static Action checkAttribute(final String name, final boolean expects) {
        return new Action(){

            public Object invoke(Invocation invocation) throws Throwable {
                ServletRequest req = (ServletRequest)invocation.getParameter(0);
                Assert.assertEquals((Object)expects, (Object)(req.getAttribute(name) != null ? 1 : 0));
                return null;
            }

            public void describeTo(Description d) {
                d.appendText("Check that request attribute ");
                d.appendValue((Object)name);
                d.appendText(" existence is ");
                d.appendValue((Object)expects);
            }
        };
    }

    public static Action returnUser() {
        return new Action(){

            public Object invoke(Invocation invocation) throws Throwable {
                User u = new User((String)invocation.getParameter(0));
                u.setFoundUser(true);
                return u;
            }

            public void describeTo(Description desc) {
                desc.appendText("return User object of provided userId");
            }
        };
    }
}

