/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util;

import java.io.File;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import uk.ac.warwick.util.core.spring.FileUtils;

public abstract class AbstractJUnit4FileBasedTest {
    protected static File root;

    @BeforeClass
    public static void setUp() throws Exception {
        File tmpRoot = File.createTempFile("fileBasedTests", null);
        String tmpName = tmpRoot.getName();
        File rootParent = tmpRoot.getParentFile();
        tmpRoot.delete();
        root = new File(rootParent, tmpName);
        if (!root.mkdir()) {
            Assert.fail((String)("Cannot create " + root));
        }
    }

    @After
    public void clean() throws Exception {
        for (File file : root.listFiles()) {
            try {
                FileUtils.recursiveDelete((File)file);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static File getRoot() {
        return root;
    }

    @AfterClass
    public static final void tearDown() throws Exception {
        try {
            FileUtils.recursiveDelete((File)root);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected File createDirectory(File directory) {
        if (!directory.mkdir()) {
            Assert.fail((String)("cannot create directory " + directory));
        }
        return directory;
    }
}

