/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.service.healthchecks.scheduling;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Provider;
import javax.inject.Singleton;
import uk.ac.warwick.util.core.scheduling.QuartzDAO;
import uk.ac.warwick.util.core.scheduling.QuartzScheduler;
import uk.ac.warwick.util.service.ServiceHealthcheck;
import uk.ac.warwick.util.service.ServiceHealthcheckProvider;

@Singleton
public abstract class AbstractQuartzSchedulerHealthcheck
extends ServiceHealthcheckProvider {
    private static final String DEFAULT_NAME = "quartz-schedulers";
    private static final int DEFAULT_MINIMUM_SCHEDULERS = 2;
    private final QuartzDAO dao;
    private final Provider<String> schedulerNameProvider;
    private final String name;
    private int minimumSchedulers = 2;

    public AbstractQuartzSchedulerHealthcheck(String name, QuartzDAO dao, Provider<String> schedulerNameProvider) {
        super(new ServiceHealthcheck(name, ServiceHealthcheck.Status.Unknown, LocalDateTime.now()));
        this.name = name;
        this.dao = dao;
        this.schedulerNameProvider = schedulerNameProvider;
    }

    public AbstractQuartzSchedulerHealthcheck(QuartzDAO dao, Provider<String> schedulerNameProvider) {
        this(DEFAULT_NAME, dao, schedulerNameProvider);
    }

    protected final ServiceHealthcheck status() {
        String scheduler = (String)this.schedulerNameProvider.get();
        Collection schedulers = this.dao.getSchedulers(scheduler);
        int totalSchedulers = schedulers.size();
        int staleSchedulers = Math.toIntExact(schedulers.stream().filter(QuartzScheduler::isStale).count());
        int activeSchedulers = totalSchedulers - staleSchedulers;
        ServiceHealthcheck.Status status = totalSchedulers < this.minimumSchedulers || activeSchedulers == 0 ? ServiceHealthcheck.Status.Error : (activeSchedulers < this.minimumSchedulers ? ServiceHealthcheck.Status.Warning : ServiceHealthcheck.Status.Okay);
        String message = staleSchedulers > 0 ? totalSchedulers + (totalSchedulers == 1 ? " scheduler" : " schedulers") + " in cluster " + scheduler + ", " + staleSchedulers + " stale" : totalSchedulers + (totalSchedulers == 1 ? " scheduler" : " schedulers") + " in cluster " + scheduler;
        return new ServiceHealthcheck(this.name, status, LocalDateTime.now(), message, Arrays.asList(new ServiceHealthcheck.PerformanceData<Integer>("scheduler_count", totalSchedulers, this.minimumSchedulers, this.minimumSchedulers), new ServiceHealthcheck.PerformanceData<Integer>("active_scheduler_count", activeSchedulers, this.minimumSchedulers, 0)));
    }

    public void setMinimumSchedulers(int minimumSchedulers) {
        this.minimumSchedulers = minimumSchedulers;
    }
}

