/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.service.spring;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.service.ServiceHealthcheck;
import uk.ac.warwick.util.service.ServiceHealthcheckProvider;
import uk.ac.warwick.util.service.ServiceMetric;
import uk.ac.warwick.util.service.ServiceMetricProvider;

@Controller
public class ServiceCheckController
implements SmartLifecycle {
    @Autowired(required=false)
    private ServiceHealthcheckProvider[] healthcheckProviders = new ServiceHealthcheckProvider[0];
    @Autowired(required=false)
    private ServiceMetricProvider[] metricProviders = new ServiceMetricProvider[0];
    @Autowired(required=false)
    @Qualifier(value="serviceCheckControllerFunction")
    private BooleanSupplier customGtgCheck;
    private boolean running = false;

    private boolean isGoodToGo() {
        return this.isRunning() && (this.customGtgCheck == null || this.customGtgCheck.getAsBoolean());
    }

    @RequestMapping(value={"/service/gtg"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> gtg() {
        if (this.isGoodToGo()) {
            return new ResponseEntity((Object)"\"OK\"", HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
    }

    @RequestMapping(value={"/service/healthcheck"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> healthcheck() throws Exception {
        if (!this.isRunning()) {
            return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
        }
        ImmutableMap.Builder json = ImmutableMap.builder();
        json.put((Object)"success", (Object)true);
        ImmutableList.Builder healthchecks = ImmutableList.builder();
        for (ServiceHealthcheckProvider provider : this.healthcheckProviders) {
            ServiceHealthcheck healthcheck = provider.latest();
            if (!healthcheck.getTestedAt().isAfter(LocalDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).minusMinutes(15L))) continue;
            healthchecks.add(provider.latest().asJson());
        }
        json.put((Object)"data", (Object)healthchecks.build());
        return new ResponseEntity((Object)json.build(), HttpStatus.OK);
    }

    @RequestMapping(value={"/service/metrics"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> metrics() throws Exception {
        if (!this.isRunning()) {
            return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
        }
        ImmutableMap.Builder json = ImmutableMap.builder();
        for (ServiceMetricProvider provider : this.metricProviders) {
            ServiceMetric metric = provider.get();
            json.put((Object)metric.getName(), metric.asJson());
        }
        return new ResponseEntity((Object)json.build(), HttpStatus.OK);
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

