/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import uk.ac.warwick.util.core.StringUtils;

public class ServiceHealthcheck {
    private final String name;
    private final Status status;
    private final LocalDateTime testedAt;
    private final String message;
    private final List<PerformanceData<?>> performanceData;

    public ServiceHealthcheck(String name, Status status, LocalDateTime testedAt) {
        this(name, status, testedAt, "", Collections.emptyList());
    }

    public ServiceHealthcheck(String name, Status status, LocalDateTime testedAt, String message) {
        this(name, status, testedAt, message, Collections.emptyList());
    }

    public ServiceHealthcheck(String name, Status status, LocalDateTime testedAt, List<PerformanceData<?>> performanceData) {
        this(name, status, testedAt, "", performanceData);
    }

    public ServiceHealthcheck(String name, Status status, LocalDateTime testedAt, String message, List<PerformanceData<?>> performanceData) {
        this.name = name;
        this.status = status;
        this.testedAt = testedAt;
        this.message = message;
        this.performanceData = Collections.unmodifiableList(performanceData);
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public LocalDateTime getTestedAt() {
        return this.testedAt;
    }

    public String getMessage() {
        return this.message;
    }

    public List<PerformanceData<?>> getPerformanceData() {
        return this.performanceData;
    }

    public Map<String, Object> asJson() {
        ImmutableMap.Builder json = ImmutableMap.builder();
        json.put((Object)"name", (Object)this.name).put((Object)"status", (Object)this.status.asString()).put((Object)"testedAt", (Object)this.testedAt.atZone(ZoneId.of("Europe/London")).withZoneSameInstant(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME));
        ImmutableList.Builder perfData = ImmutableList.builder();
        for (PerformanceData<?> data : this.performanceData) {
            perfData.add((Object)data.asString());
        }
        json.put((Object)"perfData", (Object)perfData.build());
        if (StringUtils.hasText((String)this.message)) {
            json.put((Object)"message", (Object)this.message);
        }
        return json.build();
    }

    public static class PerformanceData<T> {
        private final String name;
        private final T value;
        private final Optional<T> warningThreshold;
        private final Optional<T> errorThreshold;
        private final Optional<T> minimumValue;
        private final Optional<T> maximumValue;

        public PerformanceData(String name, T value) {
            this.name = name;
            this.value = value;
            this.warningThreshold = Optional.empty();
            this.errorThreshold = Optional.empty();
            this.minimumValue = Optional.empty();
            this.maximumValue = Optional.empty();
        }

        public PerformanceData(String name, T value, T warningThreshold, T errorThreshold) {
            this.name = name;
            this.value = value;
            this.warningThreshold = Optional.of(warningThreshold);
            this.errorThreshold = Optional.of(errorThreshold);
            this.minimumValue = Optional.empty();
            this.maximumValue = Optional.empty();
        }

        public PerformanceData(String name, T value, T warningThreshold, T errorThreshold, T minimumValue, T maximumValue) {
            this.name = name;
            this.value = value;
            this.warningThreshold = Optional.of(warningThreshold);
            this.errorThreshold = Optional.of(errorThreshold);
            this.minimumValue = Optional.of(minimumValue);
            this.maximumValue = Optional.of(maximumValue);
        }

        public String asString() {
            if (this.warningThreshold.isPresent() && this.errorThreshold.isPresent()) {
                if (this.minimumValue.isPresent() && this.maximumValue.isPresent()) {
                    return String.format("%s=%s;%s;%s;%s;%s", this.name, this.value, this.warningThreshold.get(), this.errorThreshold.get(), this.minimumValue.get(), this.maximumValue.get());
                }
                return String.format("%s=%s;%s;%s", this.name, this.value, this.warningThreshold.get(), this.errorThreshold.get());
            }
            return String.format("%s=%s", this.name, this.value);
        }

        public String getName() {
            return this.name;
        }

        public T getValue() {
            return this.value;
        }

        public Optional<T> getWarningThreshold() {
            return this.warningThreshold;
        }

        public Optional<T> getErrorThreshold() {
            return this.errorThreshold;
        }

        public Optional<T> getMinimumValue() {
            return this.minimumValue;
        }

        public Optional<T> getMaximumValue() {
            return this.maximumValue;
        }
    }

    public static enum Status {
        Okay("okay"),
        Warning("warning"),
        Error("error"),
        Unknown("unknown");

        private String asString;

        private Status(String asString) {
            this.asString = asString;
        }

        public String asString() {
            return this.asString;
        }
    }
}

