/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.queue.conversion;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import uk.ac.warwick.util.queue.QueueException;
import uk.ac.warwick.util.queue.conversion.AnnotationJsonObjectConverter;
import uk.ac.warwick.util.queue.conversion.ItemType;
import uk.ac.warwick.util.queue.conversion.JsonObjectConverter;

public class JsonMessageConverter
implements MessageConverter,
BeanFactoryAware,
InitializingBean {
    private Map<String, JsonObjectConverter> converters = Maps.newHashMap();
    private AutowireCapableBeanFactory beanFactory;
    private AnnotationJsonObjectConverter annotationConverter;
    private ObjectMapper objectMapper;

    public Object fromMessage(Message message) throws QueueException {
        try {
            TextMessage string = (TextMessage)message;
            String itemType = string.getStringProperty("itemType");
            JSONObject json = new JSONObject(string.getText());
            Object object = this.converters.get(itemType).fromJson(itemType, json);
            return object;
        }
        catch (JSONException e) {
            throw new QueueException(e);
        }
        catch (JMSException e) {
            throw new QueueException(e);
        }
    }

    public void setObjectConverters(Map<String, JsonObjectConverter> map) {
        this.converters.putAll(map);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        if (objectMapper != null && this.annotationConverter != null) {
            this.annotationConverter.setObjectMapper(objectMapper);
        }
    }

    public void setAnnotatedClasses(List<Class<?>> annotatedClasses) {
        this.annotationConverter = new AnnotationJsonObjectConverter();
        if (this.objectMapper != null) {
            this.annotationConverter.setObjectMapper(this.objectMapper);
        }
        for (Class<?> c : annotatedClasses) {
            ItemType itemType = c.getAnnotation(ItemType.class);
            if (itemType == null) {
                throw new IllegalArgumentException("Class " + c + " needs @ItemType annotation to specify a type string");
            }
            this.annotationConverter.registerType(itemType.value(), c);
            this.converters.put(itemType.value(), this.annotationConverter);
        }
    }

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        for (Map.Entry<String, JsonObjectConverter> entry : this.converters.entrySet()) {
            JsonObjectConverter converter = entry.getValue();
            if (!converter.supports(object)) continue;
            JSONObject json = converter.toJson(object);
            TextMessage textMessage = session.createTextMessage(json.toString());
            ItemType itemType = object.getClass().getAnnotation(ItemType.class);
            String type = itemType != null ? itemType.value() : entry.getKey();
            textMessage.setStringProperty("itemType", type);
            return textMessage;
        }
        throw new IllegalArgumentException("No JsonObjectConverter supports this type: " + object.getClass().getName());
    }

    public void setBeanFactory(BeanFactory beans) throws BeansException {
        this.beanFactory = (AutowireCapableBeanFactory)beans;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory != null && this.annotationConverter != null) {
            this.annotationConverter.setBeanFactory((BeanFactory)this.beanFactory);
        }
    }
}

